<? if ($i != 3) { ?>
The image created by this script is available
<a href="examples.php?i=3">here</a>.
<hr size="1" width="70%" align="left" noshade>
<? } ?>

<pre>
&lt;?php

/*
 * This example takes a source image and outputs an image with four
 * scaled copies of the image.  The original, and the image flipped
 * using the three flip functions: horizontal, vertical, and diagonal.
 *
 * The images are labeled using the ImlibText class, and a background
 * is filled behind them using a filled rectangle from the ImlibDraw class.
 */

require './class.ImlibImage.php';
require './class.ImlibColor.php';
require './class.ImlibCliprect.php';
require './class.ImlibDraw.php';
require './class.ImlibText.php';

$padding = 20;
$thumbw = 170;
$thumbh = '';	// If this is left blank, the height will be calculated
$bgarray = Array(220,115,115,255);
$textarray = Array(255,255,255,255);
$srcname = './lain-closetheworld.png';

// $mode can be 'horizontal', 'vertical', or 'diagonal'
function flipCreate($obj,$mode)
{
   $cb = &quot;flip_$mode&quot;;
   $obj-&gt;$cb();
   $new = $obj-&gt;create_clone();
   $obj-&gt;$cb();
   return $new;
}

$im = new ImlibImage();
$im-&gt;load($srcname);
$orig = $im-&gt;create_scaled($thumbw,$thumbh);
$im-&gt;free();
$imw = $orig-&gt;get_width();
$imh = $orig-&gt;get_height();

// Create the image large enough to fit four scaled copies of $srcname
$dst = new ImlibImage();
$dst-&gt;create(2*$imw + 3*$padding, 2*$imh + 5*$padding);

// Load in a font and set the color and image to draw on
$txt = new ImlibText();
$txt-&gt;set_color_array($textarray);
$txt-&gt;set_image($dst-&gt;get_id());
$txt-&gt;load('','./Vera',16);

// Get a drawing object and set its color and image to draw on
$box = new ImlibDraw();
$box-&gt;set_color_array($bgarray);
$box-&gt;set_image($dst-&gt;get_id());

$orig_alpha = $orig-&gt;has_alpha();
$box-&gt;fill_rectangle($padding-3,$padding-3, $imw+6,$imh+6);
$txt-&gt;draw($padding,$padding+$imh,'Original');
$orig-&gt;blend_onto_image($dst-&gt;get_id(),0,0,$orig_alpha,$imw,$imh,
                        $padding,$padding, $imw,$imh,0,$orig_alpha,0);

$horiz = flipCreate($orig,'horizontal');
$horiz_alpha = $horiz-&gt;has_alpha();
$box-&gt;fill_rectangle(2*$padding-3+$imw,$padding-3, $imw+6,$imh+6);
$txt-&gt;draw(2*$padding+$imw,$padding+$imh,'Horizontal');
$horiz-&gt;blend_onto_image($dst-&gt;get_id(),0,0,$horiz_alpha,$imw,$imh,
                         2*$padding+$imw,$padding, $imw,$imh,0,$horiz_alpha,0);

$vert = flipCreate($orig,'vertical');
$vert_alpha = $vert-&gt;has_alpha();
$box-&gt;fill_rectangle($padding-3,3*$padding-3+$imh, $imw+6,$imh+6);
$txt-&gt;draw($padding,3*$padding+2*$imh,'Vertical');
$vert-&gt;blend_onto_image($dst-&gt;get_id(),0,0,$vert_alpha,$imw,$imh,$padding,
                        3*$padding+$imh,$imw,$imh,0,$vert_alpha,0);

// In order to keep things simple, this image will be cropped off if it's
// not square.  This is done to keep things simple.  To show the whole
// diagonally cropped image, the dimensions for $dst would need to be
// calculated from the resulting height of the diagonal version of the image
$diag = flipCreate($orig,'diagonal');
$diag_alpha = $diag-&gt;has_alpha();
$box-&gt;fill_rectangle(2*$padding-3+$imw,3*$padding-3+$imh, $imw+6,$imh+6);
$txt-&gt;draw(2*$padding+$imw,3*$padding+2*$imh,'Diagonal');
$diag-&gt;blend_onto_image($dst-&gt;get_id(),0,0,$diag_alpha,$imw,$imh,2*$padding+$imw,
                        3*$padding+$imh,$imw,$imh,0,$diag_alpha,0);

$dst-&gt;save('./flip.png');
$dst-&gt;free();

?&gt;
</pre>
