/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-presence-manager.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_PRESENCE_MANAGER_H
#define __UNITY_WEBAPPS_PRESENCE_MANAGER_H


#define UNITY_WEBAPPS_TYPE_PRESENCE_MANAGER              (unity_webapps_presence_manager_get_type())
#define UNITY_WEBAPPS_PRESENCE_MANAGER(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_PRESENCE_MANAGER, UnityWebappsPresenceManager))
#define UNITY_WEBAPPS_PRESENCE_MANAGER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_PRESENCE_MANAGER, UnityWebappsPresenceManagerClass))
#define UNITY_WEBAPPS_IS_PRESENCE_MANAGER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_PRESENCE_MANAGER))
#define UNITY_WEBAPPS_IS_PRESENCE_MANAGER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_PRESENCE_MANAGER))
#define UNITY_WEBAPPS_PRESENCE_MANAGER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_PRESENCE_MANAGER, UnityWebappsPresenceManagerClass))

typedef struct _UnityWebappsPresenceManagerPrivate UnityWebappsPresenceManagerPrivate;

typedef struct _UnityWebappsPresenceManager UnityWebappsPresenceManager;


struct _UnityWebappsPresenceManager {
	GObject object;

	UnityWebappsPresenceManagerPrivate *priv;
};

typedef struct _UnityWebappsPresenceManagerClass UnityWebappsPresenceManagerClass;

struct _UnityWebappsPresenceManagerClass
{
	GObjectClass parent_class;
	
	gboolean (*get_presence) (UnityWebappsPresenceManager *self, gchar **status, gchar **message);
};

GType unity_webapps_presence_manager_get_type (void) G_GNUC_CONST;

gboolean unity_webapps_presence_manager_get_presence (UnityWebappsPresenceManager *manager, gchar **status, gchar **message);

#endif
