/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.amazonaws.util.json.JSONObject;

public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JSONObject> {
    public JsonErrorUnmarshaller() {
    }

    protected JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass) {
        super(exceptionClass);
    }

    @Override
    public AmazonServiceException unmarshall(JSONObject json) throws Exception {
        String message = "";
        if (json.has("message")) {
            message = json.getString("message");
        }
        AmazonServiceException ase = this.newException(message);
        String errorCode = this.parseErrorCode(json);
        ase.setErrorCode(errorCode);
        return ase;
    }

    public String parseErrorCode(JSONObject json) throws Exception {
        if (json.has("__type")) {
            String type = json.getString("__type");
            int separator = type.lastIndexOf("#");
            return type.substring(separator + 1);
        }
        return null;
    }
}

