# Normally shutdown and reboot should always go through DSME.
#
# Running reboot/poweroff/etc binaries directly bypasses DSME
# and the shutdown does not work the same way as powering off
# via UI. The differences include for example:
# - Emergency calls/alarms/charger/etc are not considered
# - Applications do not get save-data and pre-shutdown signals
# - Shutdown vibration, led and logo do not get triggered
#
# Use shell functions to allow users to continue using familiar
# commands from interactive shell, but do the shutdown/reboot
# via dsme.
#
# If needed, the real binaries (e.g. reboot) can still
# be invoked by using the full path:
# # /sbin/reboot
#
# Or by ignoring the shell functions via command:
# # command reboot

# Define shell functions for interactive shells only
case "$-" in *i*) ;; *) return ;; esac

# Replace simple poweroff/halt/reboot invocations
# with equivalent dsmetool operations

poweroff()
{
  [ "$#" -eq 0 ] && /usr/sbin/dsmetool --shutdown || /sbin/poweroff "$@"
}
halt()
{
  [ "$#" -eq 0 ] && /usr/sbin/dsmetool --shutdown || /sbin/halt "$@"
}
reboot()
{
  [ "$#" -eq 0 ] && /usr/sbin/dsmetool --reboot   || /sbin/reboot "$@"
}
