package TAP::Formatter::Color;

use strict;
use warnings;

use constant IS_WIN32 => ( $^O =~ /^(MS)?Win32$/ );

use base 'TAP::Object';

my $NO_COLOR;

BEGIN {
    $NO_COLOR = 0;

    eval 'require Term::ANSIColor';
    if ($@) {
        $NO_COLOR = $@;
    };
    if (IS_WIN32) {
        eval 'use Win32::Console::ANSI';
        if ($@) {
            $NO_COLOR = $@;
        }
    };

    if ($NO_COLOR) {
        *set_color = sub { };
    } else {
        *set_color = sub {
            my ( $self, $output, $color ) = @_;
            $output->( Term::ANSIColor::color($color) );
        };
    }
}


our $VERSION = '3.48';



sub _initialize {
    my $self = shift;

    if ($NO_COLOR) {

        # shorten that message a bit
        ( my $error = $NO_COLOR ) =~ s/ in \@INC .*//s;
        warn "Note: Cannot run tests in color: $error\n";
        return;    # abort object construction
    }

    return $self;
}



sub can_color {
    return !$NO_COLOR;
}


1;
