package ExtUtils::Mkbootstrap;

use strict;
use warnings;

our $VERSION = '7.70';
$VERSION =~ tr/_//d;

require Exporter;
our @ISA = ('Exporter');
our @EXPORT = ('&Mkbootstrap');

use Config;

our $Verbose = 0;


sub Mkbootstrap {
    my($baseext, @bsloadlibs)=@_;
    @bsloadlibs = grep($_, @bsloadlibs); # strip empty libs

    print "	bsloadlibs=@bsloadlibs\n" if $Verbose;

    # We need DynaLoader here because we and/or the *_BS file may
    # call dl_findfile(). We don't say `use' here because when
    # first building perl extensions the DynaLoader will not have
    # been built when MakeMaker gets first used.
    require DynaLoader;

    rename "$baseext.bs", "$baseext.bso"
      if -s "$baseext.bs";

    if (-f "${baseext}_BS"){
	$_ = "${baseext}_BS";
	package DynaLoader; # execute code as if in DynaLoader
	no strict 'vars';
	local($osname, $dlsrc) = (); # avoid warnings
	($osname, $dlsrc) = @Config::Config{qw(osname dlsrc)};
	$bscode = "";
	unshift @INC, ".";
	require $_;
	shift @INC;
    }

    if ($Config{'dlsrc'} =~ /^dl_dld/){
	package DynaLoader;
	no strict 'vars';
	push(@dl_resolve_using, dl_findfile('-lc'));
    }

    my(@all) = (@bsloadlibs, @DynaLoader::dl_resolve_using);
    my($method) = '';
    if (@all || (defined $DynaLoader::bscode && length $DynaLoader::bscode)){
	open my $bs, ">", "$baseext.bs"
		or die "Unable to open $baseext.bs: $!";
	print "Writing $baseext.bs\n";
	print "	containing: @all" if $Verbose;
	print $bs "# $baseext DynaLoader bootstrap file for $^O architecture.\n";
	print $bs "# Do not edit this file, changes will be lost.\n";
	print $bs "# This file was automatically generated by the\n";
	print $bs "# Mkbootstrap routine in ExtUtils::Mkbootstrap (v$VERSION).\n";
	if (@all) {
	    print $bs "\@DynaLoader::dl_resolve_using = ";
	    # If @all contains names in the form -lxxx or -Lxxx then it's asking for
	    # runtime library location so we automatically add a call to dl_findfile()
	    if (" @all" =~ m/ -[lLR]/){
		print $bs "  dl_findfile(qw(\n  @all\n  ));\n";
	    } else {
		print $bs "  qw(@all);\n";
	    }
	}
	# write extra code if *_BS says so
	print $bs $DynaLoader::bscode if $DynaLoader::bscode;
	print $bs "\n1;\n";
	close $bs;
    }
}

1;

__END__

