# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/vgcs_sms_information.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 9.1.49b VGCS SMS Information
# top-level object: VGCS SMS INFORMATION



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

segmented_sms_description_struct = CSN1List(name='segmented_sms_description_struct', list=[
  CSN1Bit(name='sms_reference_number', bit=4),
  CSN1Bit(name='segment_number', bit=4),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='sms_content', bit=-1)]),
    '1': ('', [
    CSN1Bit(name='length', bit=8),
    CSN1Bit(name='sms_final_content', bit=([1], lambda x: x))])})])

non_segmented_sms_description_struct = CSN1List(name='non_segmented_sms_description_struct', list=[
  CSN1Bit(name='length', bit=8),
  CSN1Bit(name='sms_reference_number', bit=4),
  CSN1Bit(name='sms_final_content', bit=([0], lambda x: x))])

vgcs_sms_information = CSN1List(name='vgcs_sms_information', list=[
  CSN1Bit(name='rr_short_pd'),
  CSN1Bit(name='message_type', bit=5),
  CSN1Bit(name='short_layer_2_header', bit=2),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Ref(name='non_segmented_sms_description', obj=non_segmented_sms_description_struct)]),
    '1': ('', [
    CSN1Ref(name='segmented_sms_description', obj=segmented_sms_description_struct)])}),
  CSN1Ref(obj=spare_padding)])

