# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/vgcs_neighbour_cell_information.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 9.1.57 VGCS Neighbour Cell Information message
# top-level object: VGCS Neighbour Cell Information

# external references
from pycrate_csn1dir.si10bis_rest_octets import si10bis_neighbour_cell_info

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

validity_information = CSN1Alt(name='validity_information', alt={
  '0': ('', []),
  '1': ('', [
  CSN1Bit(name='validity_bitmap', bit=3)])})

vgcs_neighbour_cell_information = CSN1List(name='vgcs_neighbour_cell_information', list=[
  CSN1Bit(name='rr_short_pd'),
  CSN1Bit(name='message_type', bit=5),
  CSN1Bit(name='short_layer_2_header', bit=2),
  CSN1Bit(name='si10bis_sequence', bit=2),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='0'),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='bsic', bit=6)])}),
    CSN1Ref(obj=validity_information)]),
  CSN1Val(name='', val='1'),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='0'),
    CSN1Ref(obj=si10bis_neighbour_cell_info)]),
  CSN1Val(name='', val='1'),
  CSN1Ref(obj=spare_padding)])

