# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/uplink_rlc_mac_control_message.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.0.2 Uplink RLC/MAC messages
# top-level object: Uplink RLC/MAC control message

# external references
from pycrate_csn1dir.packet_enhanced_measurement_report_message_content import packet_enhanced_measurement_report_message_content
from pycrate_csn1dir.mbms_downlink_ack_nack_message_content import mbms_downlink_ack_nack_message_content
from pycrate_csn1dir.packet_cs_request_message_content import packet_cs_request_message_content
from pycrate_csn1dir.ec_packet_control_acknowledgement_message_content import ec_packet_control_acknowledgement_message_content
from pycrate_csn1dir.ec_packet_downlink_ack_nack_message_content import ec_packet_downlink_ack_nack_message_content
from pycrate_csn1dir.packet_uplink_dummy_control_block_message_content import packet_uplink_dummy_control_block_message_content
from pycrate_csn1dir.additional_ms_radio_access_capabilities_message_content import additional_ms_radio_access_capabilities_message_content
from pycrate_csn1dir.mbms_service_request_message_content import mbms_service_request_message_content
from pycrate_csn1dir.packet_si_status_message_content import packet_si_status_message_content
from pycrate_csn1dir.packet_resource_request_message_content import packet_resource_request_message_content
from pycrate_csn1dir.packet_cell_change_failure_message_content import packet_cell_change_failure_message_content
from pycrate_csn1dir.egprs_packet_downlink_ack_nack_message_content import egprs_packet_downlink_ack_nack_message_content
from pycrate_csn1dir.packet_mobile_tbf_status_message_content import packet_mobile_tbf_status_message_content
from pycrate_csn1dir.egprs_packet_downlink_ack_nack_dlmc_message_content import egprs_packet_downlink_ack_nack_dlmc_message_content
from pycrate_csn1dir.packet_psi_status_message_content import packet_psi_status_message_content
from pycrate_csn1dir.packet_cell_change_notification_message_content import packet_cell_change_notification_message_content
from pycrate_csn1dir.egprs_packet_downlink_ack_nack_type_2_message_content import egprs_packet_downlink_ack_nack_type_2_message_content
from pycrate_csn1dir.egprs_packet_downlink_ack_nack_type_3_message_content import egprs_packet_downlink_ack_nack_type_3_message_content
from pycrate_csn1dir.packet_downlink_ack_nack_message_content import packet_downlink_ack_nack_message_content
from pycrate_csn1dir.packet_pause_message_content import packet_pause_message_content
from pycrate_csn1dir.packet_measurement_report_message_content import packet_measurement_report_message_content
from pycrate_csn1dir.packet_control_acknowledgement_message_content import packet_control_acknowledgement_message_content

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

uplink_rlc_mac_control_message = CSN1Alt(name='uplink_rlc_mac_control_message', alt={
  '000000': ('message_type', [
  CSN1Ref(obj=packet_cell_change_failure_message_content)]),
  '000001': ('message_type', [
  CSN1Ref(obj=packet_control_acknowledgement_message_content)]),
  '000010': ('message_type', [
  CSN1Ref(obj=packet_downlink_ack_nack_message_content)]),
  '000011': ('message_type', [
  CSN1Ref(obj=packet_uplink_dummy_control_block_message_content)]),
  '000100': ('message_type', [
  CSN1Ref(obj=packet_measurement_report_message_content)]),
  '000101': ('message_type', [
  CSN1Ref(obj=packet_resource_request_message_content)]),
  '000110': ('message_type', [
  CSN1Ref(obj=packet_mobile_tbf_status_message_content)]),
  '000111': ('message_type', [
  CSN1Ref(obj=packet_psi_status_message_content)]),
  '001000': ('message_type', [
  CSN1Ref(obj=egprs_packet_downlink_ack_nack_message_content)]),
  '001001': ('message_type', [
  CSN1Ref(obj=packet_pause_message_content)]),
  '001010': ('message_type', [
  CSN1Ref(obj=packet_enhanced_measurement_report_message_content)]),
  '001011': ('message_type', [
  CSN1Ref(obj=additional_ms_radio_access_capabilities_message_content)]),
  '001100': ('message_type', [
  CSN1Ref(obj=packet_cell_change_notification_message_content)]),
  '001101': ('message_type', [
  CSN1Ref(obj=packet_si_status_message_content)]),
  '001110': ('message_type', [
  CSN1Ref(obj=packet_cs_request_message_content)]),
  '001111': ('message_type', [
  CSN1Ref(obj=mbms_service_request_message_content)]),
  '010000': ('message_type', [
  CSN1Ref(obj=mbms_downlink_ack_nack_message_content)]),
  '010001': ('message_type', [
  CSN1Ref(obj=egprs_packet_downlink_ack_nack_type_2_message_content)]),
  '010010': ('message_type', [
  CSN1Ref(obj=egprs_packet_downlink_ack_nack_type_3_message_content)]),
  '010011': ('message_type', [
  CSN1Ref(obj=egprs_packet_downlink_ack_nack_dlmc_message_content)])})

uplink_rlc_mac_control_message_on_ec_pacch = CSN1Alt(name='uplink_rlc_mac_control_message_on_ec_pacch', alt={
  '00001': ('message_type', [
  CSN1Ref(obj=ec_packet_control_acknowledgement_message_content)]),
  '00010': ('message_type', [
  CSN1Ref(obj=ec_packet_downlink_ack_nack_message_content)])})

