# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/psi8_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.24 Packet System Information Type 8
# top-level object: PSI8 message content

# external references
from pycrate_csn1dir.frequency_parameters_ie import frequency_parameters_ie
from pycrate_csn1dir.padding_bits import padding_bits

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

cbch_channel_description_struct = CSN1List(name='cbch_channel_description_struct', list=[
  CSN1Bit(name='channel_type_and_tdma_offset', bit=5),
  CSN1Bit(name='tn', bit=3),
  CSN1Ref(name='frequency_parameters', obj=frequency_parameters_ie)])

dynamic_arfcn_mapping = CSN1List(name='dynamic_arfcn_mapping', list=[
  CSN1Bit(name='gsm_band', bit=4),
  CSN1Bit(name='arfcn_first', bit=10),
  CSN1Bit(name='band_offset', bit=10),
  CSN1Bit(name='arfcn_range', bit=7)])

dynamic_arfcn_mapping_description_struct = CSN1List(name='dynamic_arfcn_mapping_description_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='dm_change_mark', bit=4)])}),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(obj=dynamic_arfcn_mapping)]),
  CSN1Val(name='', val='0')])

psi8_message_content = CSN1List(name='psi8_message_content', list=[
  CSN1Bit(name='page_mode', bit=2),
  CSN1Bit(name='psi8_change_mark', bit=2),
  CSN1Bit(name='psi8_index', bit=3),
  CSN1Bit(name='psi8_count', bit=3),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='cbch_channel_description', obj=cbch_channel_description_struct)])}),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(bit=-1)]),
    '1': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='dynamic_arfcn_mapping_description', obj=dynamic_arfcn_mapping_description_struct)])}),
    CSN1Ref(obj=padding_bits)]),
    None: ('', [])})])

