# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/psi14_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.25a Packet System Information 14
# top-level object: PSI14 message content

# external references
from pycrate_csn1dir.frequency_parameters_ie import frequency_parameters_ie
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.gprs_cell_options_ie import gprs_cell_options_ie
from pycrate_csn1dir.gprs_power_control_parameters_ie import gprs_power_control_parameters_ie
from pycrate_csn1dir.gprs_mobile_allocation_ie import gprs_mobile_allocation_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

ccch_access_information_struct = CSN1List(name='ccch_access_information_struct', list=[
  CSN1Bit(name='bcch_change_mark', bit=3),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='si13_change_mark', bit=2),
    CSN1Ref(name='si13_mobile_allocation', obj=gprs_mobile_allocation_ie)])}),
  CSN1Bit(name='spgc_ccch_sup'),
  CSN1Bit(name='priority_access_thr', bit=3),
  CSN1Bit(name='network_control_order', bit=2),
  CSN1Ref(name='gprs_cell_options', obj=gprs_cell_options_ie),
  CSN1Ref(name='gprs_power_control_parameters', obj=gprs_power_control_parameters_ie),
  CSN1Bit(name='sgsnr'),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(bit=-1)]),
    '10': ('', [
    CSN1Bit(name='rac', bit=8),
    CSN1Bit(name='si_status_ind'),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Bit(bit=-1)]),
      '1': ('', [
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='lb_ms_txpwr_max_cch', bit=5)])}),
      CSN1Bit(name='si2n_support', bit=2)]),
      None: ('', [])})]),
    None: ('', [])})])

pbcch_description_struct_2 = CSN1List(name='pbcch_description_struct_2', list=[
  CSN1Bit(name='psi1_repeat_period', bit=4),
  CSN1Bit(name='pb', bit=4),
  CSN1Bit(name='tn', bit=3),
  CSN1Ref(name='pbcch_frequency_description', obj=frequency_parameters_ie),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(bit=-1)]),
    '11': ('', [
    CSN1Bit(name='psi_changed_ind')]),
    None: ('', [])})])

psi14_message_content = CSN1List(name='psi14_message_content', list=[
  CSN1Bit(name='page_mode', bit=2),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Ref(name='ccch_access_information', obj=ccch_access_information_struct)]),
    '1': ('', [
    CSN1Ref(name='pbcch_description', obj=pbcch_description_struct_2),
    CSN1Ref(obj=padding_bits)])})])

