# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/p1_rest_octets.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 10.5.2.23 P1 Rest Octets
# top-level object: P1 Rest Octets

# external references
from pycrate_csn1dir.mbms_sessions_list_ie import mbms_sessions_list_ie
from pycrate_csn1dir.mbms_channel_parameters_ie import mbms_channel_parameters_ie
from pycrate_csn1dir.notification_facch import group_call_information

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

etws_primary_notification_struct = CSN1List(name='etws_primary_notification_struct', list=[
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='total_no_of_segments_for_etws_primary_notification', bit=4)]),
    '1': ('', [
    CSN1Bit(name='segment_number', bit=4)])}),
  CSN1Bit(name='pni'),
  CSN1Bit(name='length_of_segment', bit=7),
  CSN1Bit(name='etws_primary_notification_data', bit=([2], lambda x: x))])

mbms_information = CSN1List(name='mbms_information', list=[
  CSN1Ref(name='mbms_sessions_list', obj=mbms_sessions_list_ie),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [])}),
    CSN1Ref(name='mbms_sessions_list', obj=mbms_sessions_list_ie)])}),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(name='mbms_channel_parameters', obj=mbms_channel_parameters_ie),
    CSN1Ref(name='mbms_sessions_list', obj=mbms_sessions_list_ie)]),
  CSN1Val(name='', val='0')])

priority = CSN1Bit(name='priority', bit=3)

p1_rest_octets = CSN1List(name='p1_rest_octets', list=[
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='nln_pch', bit=2),
    CSN1Bit(name='nln_status_pch')]),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Ref(name='priority1', obj=priority)]),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Ref(name='priority2', obj=priority)]),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Ref(obj=group_call_information)]),
    'L': ('', [])}),
  CSN1Alt(name='packet_page_indication_1', alt={
    'H': ('', []),
    'L': ('', [])}),
  CSN1Alt(name='packet_page_indication_2', alt={
    'H': ('', []),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Alt(alt={
        '00': ('', [
        CSN1Bit(name='cell_global_count', bit=2)]),
        '01': ('', [
        CSN1Bit(name='cell_global_count', bit=2),
        CSN1Bit(name='vstk_rand', bit=36)]),
        '10': ('', [
        CSN1Bit(name='reduced_gcr', bit=28),
        CSN1Bit(name='vstk_rand', bit=36)]),
        '11': ('', [
        CSN1Bit(name='cell_global_count', bit=2),
        CSN1Bit(name='reduced_gcr', bit=28),
        CSN1Bit(name='vstk_rand', bit=36)])})])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Ref(name='mbms_notification_1', obj=mbms_channel_parameters_ie)])}),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Alt(name='mbms_notification_2', alt={
          '0': ('', []),
          '1': ('', [
          CSN1Ref(obj=mbms_channel_parameters_ie)])})])}),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Ref(obj=mbms_information)])})])})]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='amr_config', bit=4)])})]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='priority_uplink_access'),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='etws_primary_notification', obj=etws_primary_notification_struct)])})]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='implicit_reject_cs'),
    CSN1Bit(name='implicit_reject_ps')]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='ipa_support')]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='peo_bcch_change_mark', bit=2),
    CSN1Bit(name='rcc', bit=3)]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Ref(obj=spare_padding)])

