# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/mbms_downlink_ack_nack_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.6d MBMS Downlink Ack/Nack
# top-level object: MBMS Downlink Ack/Nack message content

# external references
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.extension_bits_ie import extension_bits_ie
from pycrate_csn1dir.egprs_ack_nack_description_ie import egprs_ack_nack_description_ie
from pycrate_csn1dir.ack_nack_description_ie import ack_nack_description_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

neighbouring_cell_report_struct = CSN1List(name='neighbouring_cell_report_struct', list=[
  CSN1Bit(name='rxlev_serving_cell', bit=6),
  CSN1Bit(name='resel_criteria_fulfilled'),
  CSN1Bit(name='number_of_neighbouring_cell_measurements', bit=3),
  CSN1List(num=([2], lambda x: x), list=[
    CSN1Bit(name='ncell_list_index_n', bit=7),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='bsic_n', bit=6)])}),
    CSN1Bit(name='rxlev_n', bit=6),
    CSN1Bit(name='resel_params_acquired'),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='mbms_ptm_change_mark', bit=2)])})])])

mbms_neighbouring_cell_report_struct = CSN1List(name='mbms_neighbouring_cell_report_struct', list=[
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='ba_used')]),
    '1': ('', [
    CSN1Bit(name='psi3_change_mark', bit=2)])}),
  CSN1Ref(name='neighbouring_cell_report', obj=neighbouring_cell_report_struct)])

mbms_downlink_ack_nack_message_content = CSN1List(name='mbms_downlink_ack_nack_message_content', list=[
  CSN1Bit(name='downlink_tfi', bit=5),
  CSN1Ref(name='mbms_neighbouring_cell_report', obj=mbms_neighbouring_cell_report_struct),
  CSN1Bit(name='ms_id_release_indication'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='extension_bits', obj=extension_bits_ie)])}),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Ref(name='ack_nack_description', obj=ack_nack_description_ie)]),
    '1': ('', [
    CSN1Bit(name='ms_out_of_memory'),
    CSN1Ref(name='egprs_ack_nack_description', obj=egprs_ack_nack_description_ie)])}),
  CSN1Ref(obj=padding_bits)])

