# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class RUA_CommonDataTypes:

    _name_  = u'RUA-CommonDataTypes'
    _oid_   = [0, 4, 0, 0, 20, 3, 5, 1, 3]
    
    _obj_ = [
        u'maxPrivateIEs',
        u'maxProtocolExtensions',
        u'maxProtocolIEs',
        u'Criticality',
        u'Presence',
        u'ProcedureCode',
        u'PrivateIE-ID',
        u'ProtocolIE-ID',
        u'TriggeringMessage',
        ]
    _type_ = [
        u'Criticality',
        u'Presence',
        u'ProcedureCode',
        u'PrivateIE-ID',
        u'ProtocolIE-ID',
        u'TriggeringMessage',
        ]
    _set_ = [
        ]
    _val_ = [
        u'maxPrivateIEs',
        u'maxProtocolExtensions',
        u'maxProtocolIEs',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< maxPrivateIEs >-----#
    maxPrivateIEs = INT(name=u'maxPrivateIEs', mode=MODE_VALUE)
    maxPrivateIEs._val = 65535
    
    #-----< maxProtocolExtensions >-----#
    maxProtocolExtensions = INT(name=u'maxProtocolExtensions', mode=MODE_VALUE)
    maxProtocolExtensions._val = 65535
    
    #-----< maxProtocolIEs >-----#
    maxProtocolIEs = INT(name=u'maxProtocolIEs', mode=MODE_VALUE)
    maxProtocolIEs._val = 65535
    
    #-----< Criticality >-----#
    Criticality = ENUM(name=u'Criticality', mode=MODE_TYPE)
    Criticality._cont = ASN1Dict([(u'reject', 0), (u'ignore', 1), (u'notify', 2)])
    Criticality._ext = None
    
    #-----< Presence >-----#
    Presence = ENUM(name=u'Presence', mode=MODE_TYPE)
    Presence._cont = ASN1Dict([(u'optional', 0), (u'conditional', 1), (u'mandatory', 2)])
    Presence._ext = None
    
    #-----< ProcedureCode >-----#
    ProcedureCode = INT(name=u'ProcedureCode', mode=MODE_TYPE)
    ProcedureCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< PrivateIE-ID >-----#
    PrivateIE_ID = CHOICE(name=u'PrivateIE-ID', mode=MODE_TYPE)
    _PrivateIE_ID_local = INT(name=u'local', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PrivateIE_ID_local._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _PrivateIE_ID_global_ = OID(name=u'global', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    PrivateIE_ID._cont = ASN1Dict([
        (u'local', _PrivateIE_ID_local),
        (u'global', _PrivateIE_ID_global_),
        ])
    PrivateIE_ID._ext = None
    
    #-----< ProtocolIE-ID >-----#
    ProtocolIE_ID = INT(name=u'ProtocolIE-ID', mode=MODE_TYPE)
    ProtocolIE_ID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    
    #-----< TriggeringMessage >-----#
    TriggeringMessage = ENUM(name=u'TriggeringMessage', mode=MODE_TYPE)
    TriggeringMessage._cont = ASN1Dict([(u'initiating-message', 0), (u'successful-outcome', 1), (u'unsuccessful-outcome', 2)])
    TriggeringMessage._ext = None
    
    _all_ = [
        maxPrivateIEs,
        maxProtocolExtensions,
        maxProtocolIEs,
        Criticality,
        Presence,
        ProcedureCode,
        _PrivateIE_ID_local,
        _PrivateIE_ID_global_,
        PrivateIE_ID,
        ProtocolIE_ID,
        TriggeringMessage,
    ]

class RUA_Constants:

    _name_  = u'RUA-Constants'
    _oid_   = [0, 4, 0, 0, 20, 3, 5, 1, 4]
    
    _obj_ = [
        u'id-Connect',
        u'id-DirectTransfer',
        u'id-Disconnect',
        u'id-ConnectionlessTransfer',
        u'id-ErrorIndication',
        u'id-privateMessage',
        u'maxNrOfErrors',
        u'id-Cause',
        u'id-CriticalityDiagnostics',
        u'id-Context-ID',
        u'id-RANAP-Message',
        u'id-IntraDomainNasNodeSelector',
        u'id-Establishment-Cause',
        u'id-CN-DomainIndicator',
        u'id-CSGMembershipStatus',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'id-Connect',
        u'id-DirectTransfer',
        u'id-Disconnect',
        u'id-ConnectionlessTransfer',
        u'id-ErrorIndication',
        u'id-privateMessage',
        u'maxNrOfErrors',
        u'id-Cause',
        u'id-CriticalityDiagnostics',
        u'id-Context-ID',
        u'id-RANAP-Message',
        u'id-IntraDomainNasNodeSelector',
        u'id-Establishment-Cause',
        u'id-CN-DomainIndicator',
        u'id-CSGMembershipStatus',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< id-Connect >-----#
    id_Connect = INT(name=u'id-Connect', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProcedureCode')))
    id_Connect._val = 1
    
    #-----< id-DirectTransfer >-----#
    id_DirectTransfer = INT(name=u'id-DirectTransfer', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProcedureCode')))
    id_DirectTransfer._val = 2
    
    #-----< id-Disconnect >-----#
    id_Disconnect = INT(name=u'id-Disconnect', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProcedureCode')))
    id_Disconnect._val = 3
    
    #-----< id-ConnectionlessTransfer >-----#
    id_ConnectionlessTransfer = INT(name=u'id-ConnectionlessTransfer', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProcedureCode')))
    id_ConnectionlessTransfer._val = 4
    
    #-----< id-ErrorIndication >-----#
    id_ErrorIndication = INT(name=u'id-ErrorIndication', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProcedureCode')))
    id_ErrorIndication._val = 5
    
    #-----< id-privateMessage >-----#
    id_privateMessage = INT(name=u'id-privateMessage', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProcedureCode')))
    id_privateMessage._val = 6
    
    #-----< maxNrOfErrors >-----#
    maxNrOfErrors = INT(name=u'maxNrOfErrors', mode=MODE_VALUE)
    maxNrOfErrors._val = 256
    
    #-----< id-Cause >-----#
    id_Cause = INT(name=u'id-Cause', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProtocolIE-ID')))
    id_Cause._val = 1
    
    #-----< id-CriticalityDiagnostics >-----#
    id_CriticalityDiagnostics = INT(name=u'id-CriticalityDiagnostics', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProtocolIE-ID')))
    id_CriticalityDiagnostics._val = 2
    
    #-----< id-Context-ID >-----#
    id_Context_ID = INT(name=u'id-Context-ID', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProtocolIE-ID')))
    id_Context_ID._val = 3
    
    #-----< id-RANAP-Message >-----#
    id_RANAP_Message = INT(name=u'id-RANAP-Message', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProtocolIE-ID')))
    id_RANAP_Message._val = 4
    
    #-----< id-IntraDomainNasNodeSelector >-----#
    id_IntraDomainNasNodeSelector = INT(name=u'id-IntraDomainNasNodeSelector', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProtocolIE-ID')))
    id_IntraDomainNasNodeSelector._val = 5
    
    #-----< id-Establishment-Cause >-----#
    id_Establishment_Cause = INT(name=u'id-Establishment-Cause', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProtocolIE-ID')))
    id_Establishment_Cause._val = 6
    
    #-----< id-CN-DomainIndicator >-----#
    id_CN_DomainIndicator = INT(name=u'id-CN-DomainIndicator', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProtocolIE-ID')))
    id_CN_DomainIndicator._val = 7
    
    #-----< id-CSGMembershipStatus >-----#
    id_CSGMembershipStatus = INT(name=u'id-CSGMembershipStatus', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProtocolIE-ID')))
    id_CSGMembershipStatus._val = 9
    
    _all_ = [
        id_Connect,
        id_DirectTransfer,
        id_Disconnect,
        id_ConnectionlessTransfer,
        id_ErrorIndication,
        id_privateMessage,
        maxNrOfErrors,
        id_Cause,
        id_CriticalityDiagnostics,
        id_Context_ID,
        id_RANAP_Message,
        id_IntraDomainNasNodeSelector,
        id_Establishment_Cause,
        id_CN_DomainIndicator,
        id_CSGMembershipStatus,
    ]

class RUA_Containers:

    _name_  = u'RUA-Containers'
    _oid_   = [0, 4, 0, 0, 20, 3, 5, 1, 5]
    
    _obj_ = [
        u'RUA-PRIVATE-IES',
        u'RUA-PROTOCOL-IES',
        u'RUA-PROTOCOL-EXTENSION',
        u'ProtocolIE-Container',
        u'ProtocolIE-Single-Container',
        u'ProtocolIE-Field',
        u'ProtocolIE-ContainerList',
        u'ProtocolExtensionContainer',
        u'ProtocolExtensionField',
        u'PrivateIE-Container',
        u'PrivateIE-Field',
        ]
    _type_ = [
        u'RUA-PRIVATE-IES',
        u'RUA-PROTOCOL-IES',
        u'RUA-PROTOCOL-EXTENSION',
        u'ProtocolIE-Container',
        u'ProtocolIE-Single-Container',
        u'ProtocolIE-Field',
        u'ProtocolIE-ContainerList',
        u'ProtocolExtensionContainer',
        u'ProtocolExtensionField',
        u'PrivateIE-Container',
        u'PrivateIE-Field',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        u'RUA-PRIVATE-IES',
        u'RUA-PROTOCOL-IES',
        u'RUA-PROTOCOL-EXTENSION',
        ]
    _param_ = [
        u'ProtocolIE-Container',
        u'ProtocolIE-Single-Container',
        u'ProtocolIE-Field',
        u'ProtocolIE-ContainerList',
        u'ProtocolExtensionContainer',
        u'ProtocolExtensionField',
        u'PrivateIE-Container',
        u'PrivateIE-Field',
        ]
    
    #-----< RUA-PRIVATE-IES >-----#
    RUA_PRIVATE_IES = CLASS(name=u'RUA-PRIVATE-IES', mode=MODE_TYPE)
    _RUA_PRIVATE_IES_id = CHOICE(name=u'id', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'PrivateIE-ID')))
    _RUA_PRIVATE_IES_criticality = ENUM(name=u'criticality', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'Criticality')))
    _RUA_PRIVATE_IES_Value = OPEN(name=u'Value', mode=MODE_TYPE)
    _RUA_PRIVATE_IES_presence = ENUM(name=u'presence', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'Presence')))
    RUA_PRIVATE_IES._cont = ASN1Dict([
        (u'id', _RUA_PRIVATE_IES_id),
        (u'criticality', _RUA_PRIVATE_IES_criticality),
        (u'Value', _RUA_PRIVATE_IES_Value),
        (u'presence', _RUA_PRIVATE_IES_presence),
        ])
    
    #-----< RUA-PROTOCOL-IES >-----#
    RUA_PROTOCOL_IES = CLASS(name=u'RUA-PROTOCOL-IES', mode=MODE_TYPE)
    _RUA_PROTOCOL_IES_id = INT(name=u'id', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProtocolIE-ID')), uniq=True)
    _RUA_PROTOCOL_IES_criticality = ENUM(name=u'criticality', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'Criticality')))
    _RUA_PROTOCOL_IES_Value = OPEN(name=u'Value', mode=MODE_TYPE)
    _RUA_PROTOCOL_IES_presence = ENUM(name=u'presence', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'Presence')))
    RUA_PROTOCOL_IES._cont = ASN1Dict([
        (u'id', _RUA_PROTOCOL_IES_id),
        (u'criticality', _RUA_PROTOCOL_IES_criticality),
        (u'Value', _RUA_PROTOCOL_IES_Value),
        (u'presence', _RUA_PROTOCOL_IES_presence),
        ])
    
    #-----< RUA-PROTOCOL-EXTENSION >-----#
    RUA_PROTOCOL_EXTENSION = CLASS(name=u'RUA-PROTOCOL-EXTENSION', mode=MODE_TYPE)
    _RUA_PROTOCOL_EXTENSION_id = INT(name=u'id', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProtocolIE-ID')), uniq=True)
    _RUA_PROTOCOL_EXTENSION_criticality = ENUM(name=u'criticality', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'Criticality')))
    _RUA_PROTOCOL_EXTENSION_Extension = OPEN(name=u'Extension', mode=MODE_TYPE)
    _RUA_PROTOCOL_EXTENSION_presence = ENUM(name=u'presence', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'Presence')))
    RUA_PROTOCOL_EXTENSION._cont = ASN1Dict([
        (u'id', _RUA_PROTOCOL_EXTENSION_id),
        (u'criticality', _RUA_PROTOCOL_EXTENSION_criticality),
        (u'Extension', _RUA_PROTOCOL_EXTENSION_Extension),
        (u'presence', _RUA_PROTOCOL_EXTENSION_presence),
        ])
    
    #-----< ProtocolIE-Container >-----#
    ProtocolIE_Container = SEQ_OF(name=u'ProtocolIE-Container', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolIE-Single-Container >-----#
    ProtocolIE_Single_Container = SEQ(name=u'ProtocolIE-Single-Container', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolIE-Field')), param=True)
    
    #-----< ProtocolIE-Field >-----#
    ProtocolIE_Field = SEQ(name=u'ProtocolIE-Field', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolIE-ContainerList >-----#
    ProtocolIE_ContainerList = SEQ_OF(name=u'ProtocolIE-ContainerList', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolExtensionContainer >-----#
    ProtocolExtensionContainer = SEQ_OF(name=u'ProtocolExtensionContainer', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolExtensionField >-----#
    ProtocolExtensionField = SEQ(name=u'ProtocolExtensionField', mode=MODE_TYPE, param=True)
    
    #-----< PrivateIE-Container >-----#
    PrivateIE_Container = SEQ_OF(name=u'PrivateIE-Container', mode=MODE_TYPE, param=True)
    
    #-----< PrivateIE-Field >-----#
    PrivateIE_Field = SEQ(name=u'PrivateIE-Field', mode=MODE_TYPE, param=True)
    
    _all_ = [
        _RUA_PRIVATE_IES_id,
        _RUA_PRIVATE_IES_criticality,
        _RUA_PRIVATE_IES_Value,
        _RUA_PRIVATE_IES_presence,
        RUA_PRIVATE_IES,
        _RUA_PROTOCOL_IES_id,
        _RUA_PROTOCOL_IES_criticality,
        _RUA_PROTOCOL_IES_Value,
        _RUA_PROTOCOL_IES_presence,
        RUA_PROTOCOL_IES,
        _RUA_PROTOCOL_EXTENSION_id,
        _RUA_PROTOCOL_EXTENSION_criticality,
        _RUA_PROTOCOL_EXTENSION_Extension,
        _RUA_PROTOCOL_EXTENSION_presence,
        RUA_PROTOCOL_EXTENSION,
    ]

class RUA_IEs:

    _name_  = u'RUA-IEs'
    _oid_   = [0, 4, 0, 0, 20, 3, 5, 1, 2]
    
    _obj_ = [
        u'CN-DomainIndicator',
        u'CSGMembershipStatus',
        u'Establishment-Cause',
        u'Context-ID',
        u'IntraDomainNasNodeSelector',
        u'Gsm-map-IDNNS',
        u'Ansi-41-IDNNS',
        u'RANAP-Message',
        u'RoutingParameter',
        u'Cause',
        u'CauseRadioNetwork',
        u'CauseTransport',
        u'CauseProtocol',
        u'CauseMisc',
        u'CriticalityDiagnostics',
        u'CriticalityDiagnostics-IE-List',
        u'CriticalityDiagnostics-IE-List-ExtIEs',
        u'CriticalityDiagnostics-ExtIEs',
        u'TypeOfError',
        ]
    _type_ = [
        u'CN-DomainIndicator',
        u'CSGMembershipStatus',
        u'Establishment-Cause',
        u'Context-ID',
        u'IntraDomainNasNodeSelector',
        u'Gsm-map-IDNNS',
        u'Ansi-41-IDNNS',
        u'RANAP-Message',
        u'RoutingParameter',
        u'Cause',
        u'CauseRadioNetwork',
        u'CauseTransport',
        u'CauseProtocol',
        u'CauseMisc',
        u'CriticalityDiagnostics',
        u'CriticalityDiagnostics-IE-List',
        u'TypeOfError',
        ]
    _set_ = [
        u'CriticalityDiagnostics-IE-List-ExtIEs',
        u'CriticalityDiagnostics-ExtIEs',
        ]
    _val_ = [
        ]
    _class_ = [
        u'CriticalityDiagnostics-IE-List-ExtIEs',
        u'CriticalityDiagnostics-ExtIEs',
        ]
    _param_ = [
        ]
    
    #-----< CN-DomainIndicator >-----#
    CN_DomainIndicator = ENUM(name=u'CN-DomainIndicator', mode=MODE_TYPE)
    CN_DomainIndicator._cont = ASN1Dict([(u'cs-domain', 0), (u'ps-domain', 1)])
    CN_DomainIndicator._ext = None
    
    #-----< CSGMembershipStatus >-----#
    CSGMembershipStatus = ENUM(name=u'CSGMembershipStatus', mode=MODE_TYPE)
    CSGMembershipStatus._cont = ASN1Dict([(u'member', 0), (u'non-member', 1)])
    CSGMembershipStatus._ext = []
    
    #-----< Establishment-Cause >-----#
    Establishment_Cause = ENUM(name=u'Establishment-Cause', mode=MODE_TYPE)
    Establishment_Cause._cont = ASN1Dict([(u'emergency-call', 0), (u'normal-call', 1)])
    Establishment_Cause._ext = []
    
    #-----< Context-ID >-----#
    Context_ID = BIT_STR(name=u'Context-ID', mode=MODE_TYPE)
    Context_ID._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    
    #-----< IntraDomainNasNodeSelector >-----#
    IntraDomainNasNodeSelector = SEQ(name=u'IntraDomainNasNodeSelector', mode=MODE_TYPE)
    _IntraDomainNasNodeSelector_version = CHOICE(name=u'version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __IntraDomainNasNodeSelector_version_release99 = SEQ(name=u'release99', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___IntraDomainNasNodeSelector_version_release99_cn_Type = CHOICE(name=u'cn-Type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ____IntraDomainNasNodeSelector_version_release99_cn_Type_gsm_Map_IDNNS = SEQ(name=u'gsm-Map-IDNNS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'Gsm-map-IDNNS')))
    ____IntraDomainNasNodeSelector_version_release99_cn_Type_ansi_41_IDNNS = BIT_STR(name=u'ansi-41-IDNNS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'Ansi-41-IDNNS')))
    ___IntraDomainNasNodeSelector_version_release99_cn_Type._cont = ASN1Dict([
        (u'gsm-Map-IDNNS', ____IntraDomainNasNodeSelector_version_release99_cn_Type_gsm_Map_IDNNS),
        (u'ansi-41-IDNNS', ____IntraDomainNasNodeSelector_version_release99_cn_Type_ansi_41_IDNNS),
        ])
    ___IntraDomainNasNodeSelector_version_release99_cn_Type._ext = None
    __IntraDomainNasNodeSelector_version_release99._cont = ASN1Dict([
        (u'cn-Type', ___IntraDomainNasNodeSelector_version_release99_cn_Type),
        ])
    __IntraDomainNasNodeSelector_version_release99._ext = None
    __IntraDomainNasNodeSelector_version_later = SEQ(name=u'later', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___IntraDomainNasNodeSelector_version_later_futurecoding = BIT_STR(name=u'futurecoding', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___IntraDomainNasNodeSelector_version_later_futurecoding._const_sz = ASN1Set(rv=[15], rr=[], ev=None, er=[])
    __IntraDomainNasNodeSelector_version_later._cont = ASN1Dict([
        (u'futurecoding', ___IntraDomainNasNodeSelector_version_later_futurecoding),
        ])
    __IntraDomainNasNodeSelector_version_later._ext = None
    _IntraDomainNasNodeSelector_version._cont = ASN1Dict([
        (u'release99', __IntraDomainNasNodeSelector_version_release99),
        (u'later', __IntraDomainNasNodeSelector_version_later),
        ])
    _IntraDomainNasNodeSelector_version._ext = None
    IntraDomainNasNodeSelector._cont = ASN1Dict([
        (u'version', _IntraDomainNasNodeSelector_version),
        ])
    IntraDomainNasNodeSelector._ext = None
    
    #-----< Gsm-map-IDNNS >-----#
    Gsm_map_IDNNS = SEQ(name=u'Gsm-map-IDNNS', mode=MODE_TYPE)
    _Gsm_map_IDNNS_routingbasis = CHOICE(name=u'routingbasis', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __Gsm_map_IDNNS_routingbasis_localPTMSI = SEQ(name=u'localPTMSI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___Gsm_map_IDNNS_routingbasis_localPTMSI_routingparameter = BIT_STR(name=u'routingparameter', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'RoutingParameter')))
    __Gsm_map_IDNNS_routingbasis_localPTMSI._cont = ASN1Dict([
        (u'routingparameter', ___Gsm_map_IDNNS_routingbasis_localPTMSI_routingparameter),
        ])
    __Gsm_map_IDNNS_routingbasis_localPTMSI._ext = None
    __Gsm_map_IDNNS_routingbasis_tMSIofsamePLMN = SEQ(name=u'tMSIofsamePLMN', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___Gsm_map_IDNNS_routingbasis_tMSIofsamePLMN_routingparameter = BIT_STR(name=u'routingparameter', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'RoutingParameter')))
    __Gsm_map_IDNNS_routingbasis_tMSIofsamePLMN._cont = ASN1Dict([
        (u'routingparameter', ___Gsm_map_IDNNS_routingbasis_tMSIofsamePLMN_routingparameter),
        ])
    __Gsm_map_IDNNS_routingbasis_tMSIofsamePLMN._ext = None
    __Gsm_map_IDNNS_routingbasis_tMSIofdifferentPLMN = SEQ(name=u'tMSIofdifferentPLMN', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___Gsm_map_IDNNS_routingbasis_tMSIofdifferentPLMN_routingparameter = BIT_STR(name=u'routingparameter', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'RoutingParameter')))
    __Gsm_map_IDNNS_routingbasis_tMSIofdifferentPLMN._cont = ASN1Dict([
        (u'routingparameter', ___Gsm_map_IDNNS_routingbasis_tMSIofdifferentPLMN_routingparameter),
        ])
    __Gsm_map_IDNNS_routingbasis_tMSIofdifferentPLMN._ext = None
    __Gsm_map_IDNNS_routingbasis_iMSIresponsetopaging = SEQ(name=u'iMSIresponsetopaging', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___Gsm_map_IDNNS_routingbasis_iMSIresponsetopaging_routingparameter = BIT_STR(name=u'routingparameter', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'RoutingParameter')))
    __Gsm_map_IDNNS_routingbasis_iMSIresponsetopaging._cont = ASN1Dict([
        (u'routingparameter', ___Gsm_map_IDNNS_routingbasis_iMSIresponsetopaging_routingparameter),
        ])
    __Gsm_map_IDNNS_routingbasis_iMSIresponsetopaging._ext = None
    __Gsm_map_IDNNS_routingbasis_iMSIcauseUEinitiatedEvent = SEQ(name=u'iMSIcauseUEinitiatedEvent', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___Gsm_map_IDNNS_routingbasis_iMSIcauseUEinitiatedEvent_routingparameter = BIT_STR(name=u'routingparameter', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'RoutingParameter')))
    __Gsm_map_IDNNS_routingbasis_iMSIcauseUEinitiatedEvent._cont = ASN1Dict([
        (u'routingparameter', ___Gsm_map_IDNNS_routingbasis_iMSIcauseUEinitiatedEvent_routingparameter),
        ])
    __Gsm_map_IDNNS_routingbasis_iMSIcauseUEinitiatedEvent._ext = None
    __Gsm_map_IDNNS_routingbasis_iMEI = SEQ(name=u'iMEI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___Gsm_map_IDNNS_routingbasis_iMEI_routingparameter = BIT_STR(name=u'routingparameter', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'RoutingParameter')))
    __Gsm_map_IDNNS_routingbasis_iMEI._cont = ASN1Dict([
        (u'routingparameter', ___Gsm_map_IDNNS_routingbasis_iMEI_routingparameter),
        ])
    __Gsm_map_IDNNS_routingbasis_iMEI._ext = None
    __Gsm_map_IDNNS_routingbasis_spare2 = SEQ(name=u'spare2', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___Gsm_map_IDNNS_routingbasis_spare2_routingparameter = BIT_STR(name=u'routingparameter', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'RoutingParameter')))
    __Gsm_map_IDNNS_routingbasis_spare2._cont = ASN1Dict([
        (u'routingparameter', ___Gsm_map_IDNNS_routingbasis_spare2_routingparameter),
        ])
    __Gsm_map_IDNNS_routingbasis_spare2._ext = None
    __Gsm_map_IDNNS_routingbasis_spare1 = SEQ(name=u'spare1', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___Gsm_map_IDNNS_routingbasis_spare1_routingparameter = BIT_STR(name=u'routingparameter', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'RoutingParameter')))
    __Gsm_map_IDNNS_routingbasis_spare1._cont = ASN1Dict([
        (u'routingparameter', ___Gsm_map_IDNNS_routingbasis_spare1_routingparameter),
        ])
    __Gsm_map_IDNNS_routingbasis_spare1._ext = None
    _Gsm_map_IDNNS_routingbasis._cont = ASN1Dict([
        (u'localPTMSI', __Gsm_map_IDNNS_routingbasis_localPTMSI),
        (u'tMSIofsamePLMN', __Gsm_map_IDNNS_routingbasis_tMSIofsamePLMN),
        (u'tMSIofdifferentPLMN', __Gsm_map_IDNNS_routingbasis_tMSIofdifferentPLMN),
        (u'iMSIresponsetopaging', __Gsm_map_IDNNS_routingbasis_iMSIresponsetopaging),
        (u'iMSIcauseUEinitiatedEvent', __Gsm_map_IDNNS_routingbasis_iMSIcauseUEinitiatedEvent),
        (u'iMEI', __Gsm_map_IDNNS_routingbasis_iMEI),
        (u'spare2', __Gsm_map_IDNNS_routingbasis_spare2),
        (u'spare1', __Gsm_map_IDNNS_routingbasis_spare1),
        ])
    _Gsm_map_IDNNS_routingbasis._ext = None
    _Gsm_map_IDNNS_dummy = BOOL(name=u'dummy', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    Gsm_map_IDNNS._cont = ASN1Dict([
        (u'routingbasis', _Gsm_map_IDNNS_routingbasis),
        (u'dummy', _Gsm_map_IDNNS_dummy),
        ])
    Gsm_map_IDNNS._ext = None
    
    #-----< Ansi-41-IDNNS >-----#
    Ansi_41_IDNNS = BIT_STR(name=u'Ansi-41-IDNNS', mode=MODE_TYPE)
    Ansi_41_IDNNS._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    
    #-----< RANAP-Message >-----#
    RANAP_Message = OCT_STR(name=u'RANAP-Message', mode=MODE_TYPE)
    
    #-----< RoutingParameter >-----#
    RoutingParameter = BIT_STR(name=u'RoutingParameter', mode=MODE_TYPE)
    RoutingParameter._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    
    #-----< Cause >-----#
    Cause = CHOICE(name=u'Cause', mode=MODE_TYPE)
    _Cause_radioNetwork = ENUM(name=u'radioNetwork', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'CauseRadioNetwork')))
    _Cause_transport = ENUM(name=u'transport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'CauseTransport')))
    _Cause_protocol = ENUM(name=u'protocol', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'CauseProtocol')))
    _Cause_misc = ENUM(name=u'misc', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'CauseMisc')))
    Cause._cont = ASN1Dict([
        (u'radioNetwork', _Cause_radioNetwork),
        (u'transport', _Cause_transport),
        (u'protocol', _Cause_protocol),
        (u'misc', _Cause_misc),
        ])
    Cause._ext = []
    
    #-----< CauseRadioNetwork >-----#
    CauseRadioNetwork = ENUM(name=u'CauseRadioNetwork', mode=MODE_TYPE)
    CauseRadioNetwork._cont = ASN1Dict([(u'normal', 0), (u'connect-failed', 1), (u'network-release', 2), (u'unspecified', 3)])
    CauseRadioNetwork._ext = []
    
    #-----< CauseTransport >-----#
    CauseTransport = ENUM(name=u'CauseTransport', mode=MODE_TYPE)
    CauseTransport._cont = ASN1Dict([(u'transport-resource-unavailable', 0), (u'unspecified', 1)])
    CauseTransport._ext = []
    
    #-----< CauseProtocol >-----#
    CauseProtocol = ENUM(name=u'CauseProtocol', mode=MODE_TYPE)
    CauseProtocol._cont = ASN1Dict([(u'transfer-syntax-error', 0), (u'abstract-syntax-error-reject', 1), (u'abstract-syntax-error-ignore-and-notify', 2), (u'message-not-compatible-with-receiver-state', 3), (u'semantic-error', 4), (u'unspecified', 5), (u'abstract-syntax-error-falsely-constructed-message', 6)])
    CauseProtocol._ext = []
    
    #-----< CauseMisc >-----#
    CauseMisc = ENUM(name=u'CauseMisc', mode=MODE_TYPE)
    CauseMisc._cont = ASN1Dict([(u'processing-overload', 0), (u'hardware-failure', 1), (u'o-and-m-intervention', 2), (u'unspecified', 3)])
    CauseMisc._ext = []
    
    #-----< CriticalityDiagnostics >-----#
    CriticalityDiagnostics = SEQ(name=u'CriticalityDiagnostics', mode=MODE_TYPE)
    _CriticalityDiagnostics_procedureCode = INT(name=u'procedureCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProcedureCode')), opt=True)
    _CriticalityDiagnostics_triggeringMessage = ENUM(name=u'triggeringMessage', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-CommonDataTypes', 'TriggeringMessage')), opt=True)
    _CriticalityDiagnostics_procedureCriticality = ENUM(name=u'procedureCriticality', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-CommonDataTypes', 'Criticality')), opt=True)
    _CriticalityDiagnostics_iEsCriticalityDiagnostics = SEQ_OF(name=u'iEsCriticalityDiagnostics', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'CriticalityDiagnostics-IE-List')), opt=True)
    _CriticalityDiagnostics_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __CriticalityDiagnostics_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionField')))
    ___CriticalityDiagnostics_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'id']))
    ____CriticalityDiagnostics_iE_Extensions__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____CriticalityDiagnostics_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CriticalityDiagnostics_iE_Extensions__item__id._const_tab = ____CriticalityDiagnostics_iE_Extensions__item__id_tab
    ___CriticalityDiagnostics_iE_Extensions__item__id._const_tab_at = None
    ___CriticalityDiagnostics_iE_Extensions__item__id._const_tab_id = u'id'
    ___CriticalityDiagnostics_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____CriticalityDiagnostics_iE_Extensions__item__criticality_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____CriticalityDiagnostics_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CriticalityDiagnostics_iE_Extensions__item__criticality._const_tab = ____CriticalityDiagnostics_iE_Extensions__item__criticality_tab
    ___CriticalityDiagnostics_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___CriticalityDiagnostics_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____CriticalityDiagnostics_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____CriticalityDiagnostics_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue._const_tab = ____CriticalityDiagnostics_iE_Extensions__item__extensionValue_tab
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __CriticalityDiagnostics_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___CriticalityDiagnostics_iE_Extensions__item__id),
        (u'criticality', ___CriticalityDiagnostics_iE_Extensions__item__criticality),
        (u'extensionValue', ___CriticalityDiagnostics_iE_Extensions__item__extensionValue),
        ])
    __CriticalityDiagnostics_iE_Extensions__item_._ext = None
    _CriticalityDiagnostics_iE_Extensions._cont = __CriticalityDiagnostics_iE_Extensions__item_
    _CriticalityDiagnostics_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    CriticalityDiagnostics._cont = ASN1Dict([
        (u'procedureCode', _CriticalityDiagnostics_procedureCode),
        (u'triggeringMessage', _CriticalityDiagnostics_triggeringMessage),
        (u'procedureCriticality', _CriticalityDiagnostics_procedureCriticality),
        (u'iEsCriticalityDiagnostics', _CriticalityDiagnostics_iEsCriticalityDiagnostics),
        (u'iE-Extensions', _CriticalityDiagnostics_iE_Extensions),
        ])
    CriticalityDiagnostics._ext = []
    
    #-----< CriticalityDiagnostics-IE-List >-----#
    CriticalityDiagnostics_IE_List = SEQ_OF(name=u'CriticalityDiagnostics-IE-List', mode=MODE_TYPE)
    _CriticalityDiagnostics_IE_List__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __CriticalityDiagnostics_IE_List__item__iECriticality = ENUM(name=u'iECriticality', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-CommonDataTypes', 'Criticality')))
    __CriticalityDiagnostics_IE_List__item__iE_ID = INT(name=u'iE-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProtocolIE-ID')))
    __CriticalityDiagnostics_IE_List__item__typeOfError = ENUM(name=u'typeOfError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-IEs', 'TypeOfError')))
    __CriticalityDiagnostics_IE_List__item__iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionField')))
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'id']))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id._const_tab = _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id_tab
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id._const_tab_at = None
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id._const_tab_id = u'id'
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'criticality']))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality._const_tab = _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality_tab
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'Extension']))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue._const_tab = _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue_tab
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id),
        (u'criticality', ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality),
        (u'extensionValue', ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue),
        ])
    ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_._ext = None
    __CriticalityDiagnostics_IE_List__item__iE_Extensions._cont = ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_
    __CriticalityDiagnostics_IE_List__item__iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _CriticalityDiagnostics_IE_List__item_._cont = ASN1Dict([
        (u'iECriticality', __CriticalityDiagnostics_IE_List__item__iECriticality),
        (u'iE-ID', __CriticalityDiagnostics_IE_List__item__iE_ID),
        (u'typeOfError', __CriticalityDiagnostics_IE_List__item__typeOfError),
        (u'iE-Extensions', __CriticalityDiagnostics_IE_List__item__iE_Extensions),
        ])
    _CriticalityDiagnostics_IE_List__item_._ext = []
    CriticalityDiagnostics_IE_List._cont = _CriticalityDiagnostics_IE_List__item_
    CriticalityDiagnostics_IE_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    
    #-----< CriticalityDiagnostics-IE-List-ExtIEs >-----#
    CriticalityDiagnostics_IE_List_ExtIEs = CLASS(name=u'CriticalityDiagnostics-IE-List-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    CriticalityDiagnostics_IE_List_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< CriticalityDiagnostics-ExtIEs >-----#
    CriticalityDiagnostics_ExtIEs = CLASS(name=u'CriticalityDiagnostics-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    CriticalityDiagnostics_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< TypeOfError >-----#
    TypeOfError = ENUM(name=u'TypeOfError', mode=MODE_TYPE)
    TypeOfError._cont = ASN1Dict([(u'not-understood', 0), (u'missing', 1)])
    TypeOfError._ext = []
    
    _all_ = [
        CN_DomainIndicator,
        CSGMembershipStatus,
        Establishment_Cause,
        Context_ID,
        ____IntraDomainNasNodeSelector_version_release99_cn_Type_gsm_Map_IDNNS,
        ____IntraDomainNasNodeSelector_version_release99_cn_Type_ansi_41_IDNNS,
        ___IntraDomainNasNodeSelector_version_release99_cn_Type,
        __IntraDomainNasNodeSelector_version_release99,
        ___IntraDomainNasNodeSelector_version_later_futurecoding,
        __IntraDomainNasNodeSelector_version_later,
        _IntraDomainNasNodeSelector_version,
        IntraDomainNasNodeSelector,
        ___Gsm_map_IDNNS_routingbasis_localPTMSI_routingparameter,
        __Gsm_map_IDNNS_routingbasis_localPTMSI,
        ___Gsm_map_IDNNS_routingbasis_tMSIofsamePLMN_routingparameter,
        __Gsm_map_IDNNS_routingbasis_tMSIofsamePLMN,
        ___Gsm_map_IDNNS_routingbasis_tMSIofdifferentPLMN_routingparameter,
        __Gsm_map_IDNNS_routingbasis_tMSIofdifferentPLMN,
        ___Gsm_map_IDNNS_routingbasis_iMSIresponsetopaging_routingparameter,
        __Gsm_map_IDNNS_routingbasis_iMSIresponsetopaging,
        ___Gsm_map_IDNNS_routingbasis_iMSIcauseUEinitiatedEvent_routingparameter,
        __Gsm_map_IDNNS_routingbasis_iMSIcauseUEinitiatedEvent,
        ___Gsm_map_IDNNS_routingbasis_iMEI_routingparameter,
        __Gsm_map_IDNNS_routingbasis_iMEI,
        ___Gsm_map_IDNNS_routingbasis_spare2_routingparameter,
        __Gsm_map_IDNNS_routingbasis_spare2,
        ___Gsm_map_IDNNS_routingbasis_spare1_routingparameter,
        __Gsm_map_IDNNS_routingbasis_spare1,
        _Gsm_map_IDNNS_routingbasis,
        _Gsm_map_IDNNS_dummy,
        Gsm_map_IDNNS,
        Ansi_41_IDNNS,
        RANAP_Message,
        RoutingParameter,
        _Cause_radioNetwork,
        _Cause_transport,
        _Cause_protocol,
        _Cause_misc,
        Cause,
        CauseRadioNetwork,
        CauseTransport,
        CauseProtocol,
        CauseMisc,
        _CriticalityDiagnostics_procedureCode,
        _CriticalityDiagnostics_triggeringMessage,
        _CriticalityDiagnostics_procedureCriticality,
        _CriticalityDiagnostics_iEsCriticalityDiagnostics,
        ____CriticalityDiagnostics_iE_Extensions__item__id_tab,
        ___CriticalityDiagnostics_iE_Extensions__item__id,
        ____CriticalityDiagnostics_iE_Extensions__item__criticality_tab,
        ___CriticalityDiagnostics_iE_Extensions__item__criticality,
        ____CriticalityDiagnostics_iE_Extensions__item__extensionValue_tab,
        ___CriticalityDiagnostics_iE_Extensions__item__extensionValue,
        __CriticalityDiagnostics_iE_Extensions__item_,
        _CriticalityDiagnostics_iE_Extensions,
        CriticalityDiagnostics,
        __CriticalityDiagnostics_IE_List__item__iECriticality,
        __CriticalityDiagnostics_IE_List__item__iE_ID,
        __CriticalityDiagnostics_IE_List__item__typeOfError,
        _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id_tab,
        ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id,
        _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality_tab,
        ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality,
        _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue_tab,
        ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue,
        ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_,
        __CriticalityDiagnostics_IE_List__item__iE_Extensions,
        _CriticalityDiagnostics_IE_List__item_,
        CriticalityDiagnostics_IE_List,
        CriticalityDiagnostics_IE_List_ExtIEs,
        CriticalityDiagnostics_ExtIEs,
        TypeOfError,
    ]

class RUA_PDU_Contents:

    _name_  = u'RUA-PDU-Contents'
    _oid_   = [0, 4, 0, 0, 20, 3, 5, 1, 1]
    
    _obj_ = [
        u'Connect',
        u'ConnectIEs',
        u'ConnectExtensions',
        u'DirectTransfer',
        u'DirectTransferIEs',
        u'DirectTransferExtensions',
        u'Disconnect',
        u'DisconnectIEs',
        u'DisconnectExtensions',
        u'ConnectionlessTransfer',
        u'ConnectionlessTransferIEs',
        u'ConnectionlessTransferExtensions',
        u'ErrorIndication',
        u'ErrorIndicationIEs',
        u'ErrorIndicationExtensions',
        u'PrivateMessage',
        u'PrivateMessage-IEs',
        ]
    _type_ = [
        u'Connect',
        u'DirectTransfer',
        u'Disconnect',
        u'ConnectionlessTransfer',
        u'ErrorIndication',
        u'PrivateMessage',
        ]
    _set_ = [
        u'ConnectIEs',
        u'ConnectExtensions',
        u'DirectTransferIEs',
        u'DirectTransferExtensions',
        u'DisconnectIEs',
        u'DisconnectExtensions',
        u'ConnectionlessTransferIEs',
        u'ConnectionlessTransferExtensions',
        u'ErrorIndicationIEs',
        u'ErrorIndicationExtensions',
        u'PrivateMessage-IEs',
        ]
    _val_ = [
        ]
    _class_ = [
        u'ConnectIEs',
        u'ConnectExtensions',
        u'DirectTransferIEs',
        u'DirectTransferExtensions',
        u'DisconnectIEs',
        u'DisconnectExtensions',
        u'ConnectionlessTransferIEs',
        u'ConnectionlessTransferExtensions',
        u'ErrorIndicationIEs',
        u'ErrorIndicationExtensions',
        u'PrivateMessage-IEs',
        ]
    _param_ = [
        ]
    
    #-----< Connect >-----#
    Connect = SEQ(name=u'Connect', mode=MODE_TYPE)
    _Connect_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolIE-Container')))
    __Connect_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolIE-Field')))
    ___Connect_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'id']))
    ____Connect_protocolIEs__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-IES')))
    _____Connect_protocolIEs__item__id_tab_val_Value_0 = ENUM(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'CN-DomainIndicator')))
    _____Connect_protocolIEs__item__id_tab_val_Value_1 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Context-ID')))
    _____Connect_protocolIEs__item__id_tab_val_Value_2 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'IntraDomainNasNodeSelector')))
    _____Connect_protocolIEs__item__id_tab_val_Value_3 = ENUM(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Establishment-Cause')))
    _____Connect_protocolIEs__item__id_tab_val_Value_4 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'RANAP-Message')))
    ____Connect_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _____Connect_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _____Connect_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 5), (u'criticality', u'ignore'), (u'Value', _____Connect_protocolIEs__item__id_tab_val_Value_2), (u'presence', u'optional')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _____Connect_protocolIEs__item__id_tab_val_Value_3), (u'presence', u'mandatory')]), dict([(u'id', 4), (u'criticality', u'reject'), (u'Value', _____Connect_protocolIEs__item__id_tab_val_Value_4), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    ___Connect_protocolIEs__item__id._const_tab = ____Connect_protocolIEs__item__id_tab
    ___Connect_protocolIEs__item__id._const_tab_at = None
    ___Connect_protocolIEs__item__id._const_tab_id = u'id'
    ___Connect_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'criticality']))
    ___Connect_protocolIEs__item__criticality._const_tab = ____Connect_protocolIEs__item__id_tab
    ___Connect_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___Connect_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___Connect_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'Value']))
    ___Connect_protocolIEs__item__value._const_tab = ____Connect_protocolIEs__item__id_tab
    ___Connect_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___Connect_protocolIEs__item__value._const_tab_id = u'Value'
    __Connect_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___Connect_protocolIEs__item__id),
        (u'criticality', ___Connect_protocolIEs__item__criticality),
        (u'value', ___Connect_protocolIEs__item__value),
        ])
    __Connect_protocolIEs__item_._ext = None
    _Connect_protocolIEs._cont = __Connect_protocolIEs__item_
    _Connect_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _Connect_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __Connect_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionField')))
    ___Connect_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'id']))
    ____Connect_protocolExtensions__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    _____Connect_protocolExtensions__item__id_tab_val_Extension_0 = ENUM(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'CSGMembershipStatus')))
    ____Connect_protocolExtensions__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 9), (u'criticality', u'ignore'), (u'Extension', _____Connect_protocolExtensions__item__id_tab_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___Connect_protocolExtensions__item__id._const_tab = ____Connect_protocolExtensions__item__id_tab
    ___Connect_protocolExtensions__item__id._const_tab_at = None
    ___Connect_protocolExtensions__item__id._const_tab_id = u'id'
    ___Connect_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'criticality']))
    ___Connect_protocolExtensions__item__criticality._const_tab = ____Connect_protocolExtensions__item__id_tab
    ___Connect_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___Connect_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___Connect_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'Extension']))
    ___Connect_protocolExtensions__item__extensionValue._const_tab = ____Connect_protocolExtensions__item__id_tab
    ___Connect_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___Connect_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __Connect_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___Connect_protocolExtensions__item__id),
        (u'criticality', ___Connect_protocolExtensions__item__criticality),
        (u'extensionValue', ___Connect_protocolExtensions__item__extensionValue),
        ])
    __Connect_protocolExtensions__item_._ext = None
    _Connect_protocolExtensions._cont = __Connect_protocolExtensions__item_
    _Connect_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    Connect._cont = ASN1Dict([
        (u'protocolIEs', _Connect_protocolIEs),
        (u'protocolExtensions', _Connect_protocolExtensions),
        ])
    Connect._ext = []
    
    #-----< ConnectIEs >-----#
    ConnectIEs = CLASS(name=u'ConnectIEs', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-IES')))
    _ConnectIEs_val_Value_0 = ENUM(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'CN-DomainIndicator')))
    _ConnectIEs_val_Value_1 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Context-ID')))
    _ConnectIEs_val_Value_2 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'IntraDomainNasNodeSelector')))
    _ConnectIEs_val_Value_3 = ENUM(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Establishment-Cause')))
    _ConnectIEs_val_Value_4 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'RANAP-Message')))
    ConnectIEs._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _ConnectIEs_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _ConnectIEs_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 5), (u'criticality', u'ignore'), (u'Value', _ConnectIEs_val_Value_2), (u'presence', u'optional')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _ConnectIEs_val_Value_3), (u'presence', u'mandatory')]), dict([(u'id', 4), (u'criticality', u'reject'), (u'Value', _ConnectIEs_val_Value_4), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< ConnectExtensions >-----#
    ConnectExtensions = CLASS(name=u'ConnectExtensions', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    _ConnectExtensions_val_Extension_0 = ENUM(name=u'Extension', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'CSGMembershipStatus')))
    ConnectExtensions._val = ASN1Set(rv=[dict([(u'id', 9), (u'criticality', u'ignore'), (u'Extension', _ConnectExtensions_val_Extension_0), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< DirectTransfer >-----#
    DirectTransfer = SEQ(name=u'DirectTransfer', mode=MODE_TYPE)
    _DirectTransfer_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolIE-Container')))
    __DirectTransfer_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolIE-Field')))
    ___DirectTransfer_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'id']))
    ____DirectTransfer_protocolIEs__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-IES')))
    _____DirectTransfer_protocolIEs__item__id_tab_val_Value_0 = ENUM(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'CN-DomainIndicator')))
    _____DirectTransfer_protocolIEs__item__id_tab_val_Value_1 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Context-ID')))
    _____DirectTransfer_protocolIEs__item__id_tab_val_Value_2 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'RANAP-Message')))
    ____DirectTransfer_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _____DirectTransfer_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _____DirectTransfer_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 4), (u'criticality', u'reject'), (u'Value', _____DirectTransfer_protocolIEs__item__id_tab_val_Value_2), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    ___DirectTransfer_protocolIEs__item__id._const_tab = ____DirectTransfer_protocolIEs__item__id_tab
    ___DirectTransfer_protocolIEs__item__id._const_tab_at = None
    ___DirectTransfer_protocolIEs__item__id._const_tab_id = u'id'
    ___DirectTransfer_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'criticality']))
    ___DirectTransfer_protocolIEs__item__criticality._const_tab = ____DirectTransfer_protocolIEs__item__id_tab
    ___DirectTransfer_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___DirectTransfer_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___DirectTransfer_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'Value']))
    ___DirectTransfer_protocolIEs__item__value._const_tab = ____DirectTransfer_protocolIEs__item__id_tab
    ___DirectTransfer_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___DirectTransfer_protocolIEs__item__value._const_tab_id = u'Value'
    __DirectTransfer_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___DirectTransfer_protocolIEs__item__id),
        (u'criticality', ___DirectTransfer_protocolIEs__item__criticality),
        (u'value', ___DirectTransfer_protocolIEs__item__value),
        ])
    __DirectTransfer_protocolIEs__item_._ext = None
    _DirectTransfer_protocolIEs._cont = __DirectTransfer_protocolIEs__item_
    _DirectTransfer_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _DirectTransfer_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __DirectTransfer_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionField')))
    ___DirectTransfer_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'id']))
    ____DirectTransfer_protocolExtensions__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____DirectTransfer_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DirectTransfer_protocolExtensions__item__id._const_tab = ____DirectTransfer_protocolExtensions__item__id_tab
    ___DirectTransfer_protocolExtensions__item__id._const_tab_at = None
    ___DirectTransfer_protocolExtensions__item__id._const_tab_id = u'id'
    ___DirectTransfer_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____DirectTransfer_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____DirectTransfer_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DirectTransfer_protocolExtensions__item__criticality._const_tab = ____DirectTransfer_protocolExtensions__item__criticality_tab
    ___DirectTransfer_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___DirectTransfer_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___DirectTransfer_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____DirectTransfer_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____DirectTransfer_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DirectTransfer_protocolExtensions__item__extensionValue._const_tab = ____DirectTransfer_protocolExtensions__item__extensionValue_tab
    ___DirectTransfer_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___DirectTransfer_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __DirectTransfer_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___DirectTransfer_protocolExtensions__item__id),
        (u'criticality', ___DirectTransfer_protocolExtensions__item__criticality),
        (u'extensionValue', ___DirectTransfer_protocolExtensions__item__extensionValue),
        ])
    __DirectTransfer_protocolExtensions__item_._ext = None
    _DirectTransfer_protocolExtensions._cont = __DirectTransfer_protocolExtensions__item_
    _DirectTransfer_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    DirectTransfer._cont = ASN1Dict([
        (u'protocolIEs', _DirectTransfer_protocolIEs),
        (u'protocolExtensions', _DirectTransfer_protocolExtensions),
        ])
    DirectTransfer._ext = []
    
    #-----< DirectTransferIEs >-----#
    DirectTransferIEs = CLASS(name=u'DirectTransferIEs', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-IES')))
    _DirectTransferIEs_val_Value_0 = ENUM(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'CN-DomainIndicator')))
    _DirectTransferIEs_val_Value_1 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Context-ID')))
    _DirectTransferIEs_val_Value_2 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'RANAP-Message')))
    DirectTransferIEs._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _DirectTransferIEs_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _DirectTransferIEs_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 4), (u'criticality', u'reject'), (u'Value', _DirectTransferIEs_val_Value_2), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< DirectTransferExtensions >-----#
    DirectTransferExtensions = CLASS(name=u'DirectTransferExtensions', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    DirectTransferExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< Disconnect >-----#
    Disconnect = SEQ(name=u'Disconnect', mode=MODE_TYPE)
    _Disconnect_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolIE-Container')))
    __Disconnect_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolIE-Field')))
    ___Disconnect_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'id']))
    ____Disconnect_protocolIEs__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-IES')))
    _____Disconnect_protocolIEs__item__id_tab_val_Value_0 = ENUM(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'CN-DomainIndicator')))
    _____Disconnect_protocolIEs__item__id_tab_val_Value_1 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Context-ID')))
    _____Disconnect_protocolIEs__item__id_tab_val_Value_2 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Cause')))
    _____Disconnect_protocolIEs__item__id_tab_val_Value_3 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'RANAP-Message')))
    ____Disconnect_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _____Disconnect_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _____Disconnect_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 1), (u'criticality', u'reject'), (u'Value', _____Disconnect_protocolIEs__item__id_tab_val_Value_2), (u'presence', u'mandatory')]), dict([(u'id', 4), (u'criticality', u'reject'), (u'Value', _____Disconnect_protocolIEs__item__id_tab_val_Value_3), (u'presence', u'conditional')])], rr=[], ev=None, er=[])
    ___Disconnect_protocolIEs__item__id._const_tab = ____Disconnect_protocolIEs__item__id_tab
    ___Disconnect_protocolIEs__item__id._const_tab_at = None
    ___Disconnect_protocolIEs__item__id._const_tab_id = u'id'
    ___Disconnect_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'criticality']))
    ___Disconnect_protocolIEs__item__criticality._const_tab = ____Disconnect_protocolIEs__item__id_tab
    ___Disconnect_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___Disconnect_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___Disconnect_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'Value']))
    ___Disconnect_protocolIEs__item__value._const_tab = ____Disconnect_protocolIEs__item__id_tab
    ___Disconnect_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___Disconnect_protocolIEs__item__value._const_tab_id = u'Value'
    __Disconnect_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___Disconnect_protocolIEs__item__id),
        (u'criticality', ___Disconnect_protocolIEs__item__criticality),
        (u'value', ___Disconnect_protocolIEs__item__value),
        ])
    __Disconnect_protocolIEs__item_._ext = None
    _Disconnect_protocolIEs._cont = __Disconnect_protocolIEs__item_
    _Disconnect_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _Disconnect_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __Disconnect_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionField')))
    ___Disconnect_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'id']))
    ____Disconnect_protocolExtensions__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____Disconnect_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Disconnect_protocolExtensions__item__id._const_tab = ____Disconnect_protocolExtensions__item__id_tab
    ___Disconnect_protocolExtensions__item__id._const_tab_at = None
    ___Disconnect_protocolExtensions__item__id._const_tab_id = u'id'
    ___Disconnect_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____Disconnect_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____Disconnect_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Disconnect_protocolExtensions__item__criticality._const_tab = ____Disconnect_protocolExtensions__item__criticality_tab
    ___Disconnect_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___Disconnect_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___Disconnect_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____Disconnect_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____Disconnect_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Disconnect_protocolExtensions__item__extensionValue._const_tab = ____Disconnect_protocolExtensions__item__extensionValue_tab
    ___Disconnect_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___Disconnect_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __Disconnect_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___Disconnect_protocolExtensions__item__id),
        (u'criticality', ___Disconnect_protocolExtensions__item__criticality),
        (u'extensionValue', ___Disconnect_protocolExtensions__item__extensionValue),
        ])
    __Disconnect_protocolExtensions__item_._ext = None
    _Disconnect_protocolExtensions._cont = __Disconnect_protocolExtensions__item_
    _Disconnect_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    Disconnect._cont = ASN1Dict([
        (u'protocolIEs', _Disconnect_protocolIEs),
        (u'protocolExtensions', _Disconnect_protocolExtensions),
        ])
    Disconnect._ext = []
    
    #-----< DisconnectIEs >-----#
    DisconnectIEs = CLASS(name=u'DisconnectIEs', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-IES')))
    _DisconnectIEs_val_Value_0 = ENUM(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'CN-DomainIndicator')))
    _DisconnectIEs_val_Value_1 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Context-ID')))
    _DisconnectIEs_val_Value_2 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Cause')))
    _DisconnectIEs_val_Value_3 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'RANAP-Message')))
    DisconnectIEs._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _DisconnectIEs_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _DisconnectIEs_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 1), (u'criticality', u'reject'), (u'Value', _DisconnectIEs_val_Value_2), (u'presence', u'mandatory')]), dict([(u'id', 4), (u'criticality', u'reject'), (u'Value', _DisconnectIEs_val_Value_3), (u'presence', u'conditional')])], rr=[], ev=[], er=[])
    
    #-----< DisconnectExtensions >-----#
    DisconnectExtensions = CLASS(name=u'DisconnectExtensions', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    DisconnectExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< ConnectionlessTransfer >-----#
    ConnectionlessTransfer = SEQ(name=u'ConnectionlessTransfer', mode=MODE_TYPE)
    _ConnectionlessTransfer_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolIE-Container')))
    __ConnectionlessTransfer_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolIE-Field')))
    ___ConnectionlessTransfer_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'id']))
    ____ConnectionlessTransfer_protocolIEs__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-IES')))
    _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_0 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'RANAP-Message')))
    ____ConnectionlessTransfer_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 4), (u'criticality', u'reject'), (u'Value', _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    ___ConnectionlessTransfer_protocolIEs__item__id._const_tab = ____ConnectionlessTransfer_protocolIEs__item__id_tab
    ___ConnectionlessTransfer_protocolIEs__item__id._const_tab_at = None
    ___ConnectionlessTransfer_protocolIEs__item__id._const_tab_id = u'id'
    ___ConnectionlessTransfer_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'criticality']))
    ___ConnectionlessTransfer_protocolIEs__item__criticality._const_tab = ____ConnectionlessTransfer_protocolIEs__item__id_tab
    ___ConnectionlessTransfer_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___ConnectionlessTransfer_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___ConnectionlessTransfer_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'Value']))
    ___ConnectionlessTransfer_protocolIEs__item__value._const_tab = ____ConnectionlessTransfer_protocolIEs__item__id_tab
    ___ConnectionlessTransfer_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___ConnectionlessTransfer_protocolIEs__item__value._const_tab_id = u'Value'
    __ConnectionlessTransfer_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___ConnectionlessTransfer_protocolIEs__item__id),
        (u'criticality', ___ConnectionlessTransfer_protocolIEs__item__criticality),
        (u'value', ___ConnectionlessTransfer_protocolIEs__item__value),
        ])
    __ConnectionlessTransfer_protocolIEs__item_._ext = None
    _ConnectionlessTransfer_protocolIEs._cont = __ConnectionlessTransfer_protocolIEs__item_
    _ConnectionlessTransfer_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _ConnectionlessTransfer_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __ConnectionlessTransfer_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionField')))
    ___ConnectionlessTransfer_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'id']))
    ____ConnectionlessTransfer_protocolExtensions__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____ConnectionlessTransfer_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ConnectionlessTransfer_protocolExtensions__item__id._const_tab = ____ConnectionlessTransfer_protocolExtensions__item__id_tab
    ___ConnectionlessTransfer_protocolExtensions__item__id._const_tab_at = None
    ___ConnectionlessTransfer_protocolExtensions__item__id._const_tab_id = u'id'
    ___ConnectionlessTransfer_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____ConnectionlessTransfer_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____ConnectionlessTransfer_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ConnectionlessTransfer_protocolExtensions__item__criticality._const_tab = ____ConnectionlessTransfer_protocolExtensions__item__criticality_tab
    ___ConnectionlessTransfer_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___ConnectionlessTransfer_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___ConnectionlessTransfer_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____ConnectionlessTransfer_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____ConnectionlessTransfer_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ConnectionlessTransfer_protocolExtensions__item__extensionValue._const_tab = ____ConnectionlessTransfer_protocolExtensions__item__extensionValue_tab
    ___ConnectionlessTransfer_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___ConnectionlessTransfer_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __ConnectionlessTransfer_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___ConnectionlessTransfer_protocolExtensions__item__id),
        (u'criticality', ___ConnectionlessTransfer_protocolExtensions__item__criticality),
        (u'extensionValue', ___ConnectionlessTransfer_protocolExtensions__item__extensionValue),
        ])
    __ConnectionlessTransfer_protocolExtensions__item_._ext = None
    _ConnectionlessTransfer_protocolExtensions._cont = __ConnectionlessTransfer_protocolExtensions__item_
    _ConnectionlessTransfer_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    ConnectionlessTransfer._cont = ASN1Dict([
        (u'protocolIEs', _ConnectionlessTransfer_protocolIEs),
        (u'protocolExtensions', _ConnectionlessTransfer_protocolExtensions),
        ])
    ConnectionlessTransfer._ext = []
    
    #-----< ConnectionlessTransferIEs >-----#
    ConnectionlessTransferIEs = CLASS(name=u'ConnectionlessTransferIEs', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-IES')))
    _ConnectionlessTransferIEs_val_Value_0 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'RANAP-Message')))
    ConnectionlessTransferIEs._val = ASN1Set(rv=[dict([(u'id', 4), (u'criticality', u'reject'), (u'Value', _ConnectionlessTransferIEs_val_Value_0), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< ConnectionlessTransferExtensions >-----#
    ConnectionlessTransferExtensions = CLASS(name=u'ConnectionlessTransferExtensions', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ConnectionlessTransferExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< ErrorIndication >-----#
    ErrorIndication = SEQ(name=u'ErrorIndication', mode=MODE_TYPE)
    _ErrorIndication_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolIE-Container')))
    __ErrorIndication_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolIE-Field')))
    ___ErrorIndication_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'id']))
    ____ErrorIndication_protocolIEs__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-IES')))
    _____ErrorIndication_protocolIEs__item__id_tab_val_Value_0 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Cause')))
    _____ErrorIndication_protocolIEs__item__id_tab_val_Value_1 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'CriticalityDiagnostics')))
    ____ErrorIndication_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 1), (u'criticality', u'ignore'), (u'Value', _____ErrorIndication_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 2), (u'criticality', u'ignore'), (u'Value', _____ErrorIndication_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'optional')])], rr=[], ev=None, er=[])
    ___ErrorIndication_protocolIEs__item__id._const_tab = ____ErrorIndication_protocolIEs__item__id_tab
    ___ErrorIndication_protocolIEs__item__id._const_tab_at = None
    ___ErrorIndication_protocolIEs__item__id._const_tab_id = u'id'
    ___ErrorIndication_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'criticality']))
    ___ErrorIndication_protocolIEs__item__criticality._const_tab = ____ErrorIndication_protocolIEs__item__id_tab
    ___ErrorIndication_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___ErrorIndication_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___ErrorIndication_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-IES'), [u'Value']))
    ___ErrorIndication_protocolIEs__item__value._const_tab = ____ErrorIndication_protocolIEs__item__id_tab
    ___ErrorIndication_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___ErrorIndication_protocolIEs__item__value._const_tab_id = u'Value'
    __ErrorIndication_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___ErrorIndication_protocolIEs__item__id),
        (u'criticality', ___ErrorIndication_protocolIEs__item__criticality),
        (u'value', ___ErrorIndication_protocolIEs__item__value),
        ])
    __ErrorIndication_protocolIEs__item_._ext = None
    _ErrorIndication_protocolIEs._cont = __ErrorIndication_protocolIEs__item_
    _ErrorIndication_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _ErrorIndication_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __ErrorIndication_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'ProtocolExtensionField')))
    ___ErrorIndication_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'id']))
    ____ErrorIndication_protocolExtensions__item__id_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____ErrorIndication_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ErrorIndication_protocolExtensions__item__id._const_tab = ____ErrorIndication_protocolExtensions__item__id_tab
    ___ErrorIndication_protocolExtensions__item__id._const_tab_at = None
    ___ErrorIndication_protocolExtensions__item__id._const_tab_id = u'id'
    ___ErrorIndication_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____ErrorIndication_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____ErrorIndication_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ErrorIndication_protocolExtensions__item__criticality._const_tab = ____ErrorIndication_protocolExtensions__item__criticality_tab
    ___ErrorIndication_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___ErrorIndication_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___ErrorIndication_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____ErrorIndication_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RUA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ____ErrorIndication_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ErrorIndication_protocolExtensions__item__extensionValue._const_tab = ____ErrorIndication_protocolExtensions__item__extensionValue_tab
    ___ErrorIndication_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___ErrorIndication_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __ErrorIndication_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___ErrorIndication_protocolExtensions__item__id),
        (u'criticality', ___ErrorIndication_protocolExtensions__item__criticality),
        (u'extensionValue', ___ErrorIndication_protocolExtensions__item__extensionValue),
        ])
    __ErrorIndication_protocolExtensions__item_._ext = None
    _ErrorIndication_protocolExtensions._cont = __ErrorIndication_protocolExtensions__item_
    _ErrorIndication_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    ErrorIndication._cont = ASN1Dict([
        (u'protocolIEs', _ErrorIndication_protocolIEs),
        (u'protocolExtensions', _ErrorIndication_protocolExtensions),
        ])
    ErrorIndication._ext = []
    
    #-----< ErrorIndicationIEs >-----#
    ErrorIndicationIEs = CLASS(name=u'ErrorIndicationIEs', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-IES')))
    _ErrorIndicationIEs_val_Value_0 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'Cause')))
    _ErrorIndicationIEs_val_Value_1 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-IEs', 'CriticalityDiagnostics')))
    ErrorIndicationIEs._val = ASN1Set(rv=[dict([(u'id', 1), (u'criticality', u'ignore'), (u'Value', _ErrorIndicationIEs_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 2), (u'criticality', u'ignore'), (u'Value', _ErrorIndicationIEs_val_Value_1), (u'presence', u'optional')])], rr=[], ev=[], er=[])
    
    #-----< ErrorIndicationExtensions >-----#
    ErrorIndicationExtensions = CLASS(name=u'ErrorIndicationExtensions', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PROTOCOL-EXTENSION')))
    ErrorIndicationExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< PrivateMessage >-----#
    PrivateMessage = SEQ(name=u'PrivateMessage', mode=MODE_TYPE)
    _PrivateMessage_privateIEs = SEQ_OF(name=u'privateIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-Containers', 'PrivateIE-Container')))
    __PrivateMessage_privateIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-Containers', 'PrivateIE-Field')))
    ___PrivateMessage_privateIEs__item__id = CHOICE(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PRIVATE-IES'), [u'id']))
    ____PrivateMessage_privateIEs__item__id_tab = CLASS(name='_tab_RUA-PRIVATE-IES', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PRIVATE-IES')))
    ____PrivateMessage_privateIEs__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___PrivateMessage_privateIEs__item__id._const_tab = ____PrivateMessage_privateIEs__item__id_tab
    ___PrivateMessage_privateIEs__item__id._const_tab_at = None
    ___PrivateMessage_privateIEs__item__id._const_tab_id = u'id'
    ___PrivateMessage_privateIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PRIVATE-IES'), [u'criticality']))
    ____PrivateMessage_privateIEs__item__criticality_tab = CLASS(name='_tab_RUA-PRIVATE-IES', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PRIVATE-IES')))
    ____PrivateMessage_privateIEs__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___PrivateMessage_privateIEs__item__criticality._const_tab = ____PrivateMessage_privateIEs__item__criticality_tab
    ___PrivateMessage_privateIEs__item__criticality._const_tab_at = ('..', u'id')
    ___PrivateMessage_privateIEs__item__criticality._const_tab_id = u'criticality'
    ___PrivateMessage_privateIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-Containers', 'RUA-PRIVATE-IES'), [u'Value']))
    ____PrivateMessage_privateIEs__item__value_tab = CLASS(name='_tab_RUA-PRIVATE-IES', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PRIVATE-IES')))
    ____PrivateMessage_privateIEs__item__value_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___PrivateMessage_privateIEs__item__value._const_tab = ____PrivateMessage_privateIEs__item__value_tab
    ___PrivateMessage_privateIEs__item__value._const_tab_at = ('..', u'id')
    ___PrivateMessage_privateIEs__item__value._const_tab_id = u'Value'
    __PrivateMessage_privateIEs__item_._cont = ASN1Dict([
        (u'id', ___PrivateMessage_privateIEs__item__id),
        (u'criticality', ___PrivateMessage_privateIEs__item__criticality),
        (u'value', ___PrivateMessage_privateIEs__item__value),
        ])
    __PrivateMessage_privateIEs__item_._ext = None
    _PrivateMessage_privateIEs._cont = __PrivateMessage_privateIEs__item_
    _PrivateMessage_privateIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    PrivateMessage._cont = ASN1Dict([
        (u'privateIEs', _PrivateMessage_privateIEs),
        ])
    PrivateMessage._ext = []
    
    #-----< PrivateMessage-IEs >-----#
    PrivateMessage_IEs = CLASS(name=u'PrivateMessage-IEs', mode=MODE_SET, typeref=ASN1RefType(('RUA-Containers', 'RUA-PRIVATE-IES')))
    PrivateMessage_IEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    _all_ = [
        ____Connect_protocolIEs__item__id_tab,
        _____Connect_protocolIEs__item__id_tab_val_Value_0,
        _____Connect_protocolIEs__item__id_tab_val_Value_1,
        _____Connect_protocolIEs__item__id_tab_val_Value_2,
        _____Connect_protocolIEs__item__id_tab_val_Value_3,
        _____Connect_protocolIEs__item__id_tab_val_Value_4,
        ___Connect_protocolIEs__item__id,
        ___Connect_protocolIEs__item__criticality,
        ___Connect_protocolIEs__item__value,
        __Connect_protocolIEs__item_,
        _Connect_protocolIEs,
        ____Connect_protocolExtensions__item__id_tab,
        _____Connect_protocolExtensions__item__id_tab_val_Extension_0,
        ___Connect_protocolExtensions__item__id,
        ___Connect_protocolExtensions__item__criticality,
        ___Connect_protocolExtensions__item__extensionValue,
        __Connect_protocolExtensions__item_,
        _Connect_protocolExtensions,
        Connect,
        ConnectIEs,
        _ConnectIEs_val_Value_0,
        _ConnectIEs_val_Value_1,
        _ConnectIEs_val_Value_2,
        _ConnectIEs_val_Value_3,
        _ConnectIEs_val_Value_4,
        ConnectExtensions,
        _ConnectExtensions_val_Extension_0,
        ____DirectTransfer_protocolIEs__item__id_tab,
        _____DirectTransfer_protocolIEs__item__id_tab_val_Value_0,
        _____DirectTransfer_protocolIEs__item__id_tab_val_Value_1,
        _____DirectTransfer_protocolIEs__item__id_tab_val_Value_2,
        ___DirectTransfer_protocolIEs__item__id,
        ___DirectTransfer_protocolIEs__item__criticality,
        ___DirectTransfer_protocolIEs__item__value,
        __DirectTransfer_protocolIEs__item_,
        _DirectTransfer_protocolIEs,
        ____DirectTransfer_protocolExtensions__item__id_tab,
        ___DirectTransfer_protocolExtensions__item__id,
        ____DirectTransfer_protocolExtensions__item__criticality_tab,
        ___DirectTransfer_protocolExtensions__item__criticality,
        ____DirectTransfer_protocolExtensions__item__extensionValue_tab,
        ___DirectTransfer_protocolExtensions__item__extensionValue,
        __DirectTransfer_protocolExtensions__item_,
        _DirectTransfer_protocolExtensions,
        DirectTransfer,
        DirectTransferIEs,
        _DirectTransferIEs_val_Value_0,
        _DirectTransferIEs_val_Value_1,
        _DirectTransferIEs_val_Value_2,
        DirectTransferExtensions,
        ____Disconnect_protocolIEs__item__id_tab,
        _____Disconnect_protocolIEs__item__id_tab_val_Value_0,
        _____Disconnect_protocolIEs__item__id_tab_val_Value_1,
        _____Disconnect_protocolIEs__item__id_tab_val_Value_2,
        _____Disconnect_protocolIEs__item__id_tab_val_Value_3,
        ___Disconnect_protocolIEs__item__id,
        ___Disconnect_protocolIEs__item__criticality,
        ___Disconnect_protocolIEs__item__value,
        __Disconnect_protocolIEs__item_,
        _Disconnect_protocolIEs,
        ____Disconnect_protocolExtensions__item__id_tab,
        ___Disconnect_protocolExtensions__item__id,
        ____Disconnect_protocolExtensions__item__criticality_tab,
        ___Disconnect_protocolExtensions__item__criticality,
        ____Disconnect_protocolExtensions__item__extensionValue_tab,
        ___Disconnect_protocolExtensions__item__extensionValue,
        __Disconnect_protocolExtensions__item_,
        _Disconnect_protocolExtensions,
        Disconnect,
        DisconnectIEs,
        _DisconnectIEs_val_Value_0,
        _DisconnectIEs_val_Value_1,
        _DisconnectIEs_val_Value_2,
        _DisconnectIEs_val_Value_3,
        DisconnectExtensions,
        ____ConnectionlessTransfer_protocolIEs__item__id_tab,
        _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_0,
        ___ConnectionlessTransfer_protocolIEs__item__id,
        ___ConnectionlessTransfer_protocolIEs__item__criticality,
        ___ConnectionlessTransfer_protocolIEs__item__value,
        __ConnectionlessTransfer_protocolIEs__item_,
        _ConnectionlessTransfer_protocolIEs,
        ____ConnectionlessTransfer_protocolExtensions__item__id_tab,
        ___ConnectionlessTransfer_protocolExtensions__item__id,
        ____ConnectionlessTransfer_protocolExtensions__item__criticality_tab,
        ___ConnectionlessTransfer_protocolExtensions__item__criticality,
        ____ConnectionlessTransfer_protocolExtensions__item__extensionValue_tab,
        ___ConnectionlessTransfer_protocolExtensions__item__extensionValue,
        __ConnectionlessTransfer_protocolExtensions__item_,
        _ConnectionlessTransfer_protocolExtensions,
        ConnectionlessTransfer,
        ConnectionlessTransferIEs,
        _ConnectionlessTransferIEs_val_Value_0,
        ConnectionlessTransferExtensions,
        ____ErrorIndication_protocolIEs__item__id_tab,
        _____ErrorIndication_protocolIEs__item__id_tab_val_Value_0,
        _____ErrorIndication_protocolIEs__item__id_tab_val_Value_1,
        ___ErrorIndication_protocolIEs__item__id,
        ___ErrorIndication_protocolIEs__item__criticality,
        ___ErrorIndication_protocolIEs__item__value,
        __ErrorIndication_protocolIEs__item_,
        _ErrorIndication_protocolIEs,
        ____ErrorIndication_protocolExtensions__item__id_tab,
        ___ErrorIndication_protocolExtensions__item__id,
        ____ErrorIndication_protocolExtensions__item__criticality_tab,
        ___ErrorIndication_protocolExtensions__item__criticality,
        ____ErrorIndication_protocolExtensions__item__extensionValue_tab,
        ___ErrorIndication_protocolExtensions__item__extensionValue,
        __ErrorIndication_protocolExtensions__item_,
        _ErrorIndication_protocolExtensions,
        ErrorIndication,
        ErrorIndicationIEs,
        _ErrorIndicationIEs_val_Value_0,
        _ErrorIndicationIEs_val_Value_1,
        ErrorIndicationExtensions,
        ____PrivateMessage_privateIEs__item__id_tab,
        ___PrivateMessage_privateIEs__item__id,
        ____PrivateMessage_privateIEs__item__criticality_tab,
        ___PrivateMessage_privateIEs__item__criticality,
        ____PrivateMessage_privateIEs__item__value_tab,
        ___PrivateMessage_privateIEs__item__value,
        __PrivateMessage_privateIEs__item_,
        _PrivateMessage_privateIEs,
        PrivateMessage,
        PrivateMessage_IEs,
    ]

class RUA_PDU_Descriptions:

    _name_  = u'RUA-PDU-Descriptions'
    _oid_   = [0, 4, 0, 0, 20, 3, 5, 1, 0]
    
    _obj_ = [
        u'RUA-ELEMENTARY-PROCEDURE',
        u'RUA-PDU',
        u'InitiatingMessage',
        u'SuccessfulOutcome',
        u'UnsuccessfulOutcome',
        u'RUA-ELEMENTARY-PROCEDURES',
        u'RUA-ELEMENTARY-PROCEDURES-CLASS-1',
        u'RUA-ELEMENTARY-PROCEDURES-CLASS-2',
        u'connectionRequest',
        u'directTransfer',
        u'disconnectRequest',
        u'connectionlessTransfer',
        u'errorIndication',
        u'privateMessage',
        ]
    _type_ = [
        u'RUA-ELEMENTARY-PROCEDURE',
        u'RUA-PDU',
        u'InitiatingMessage',
        u'SuccessfulOutcome',
        u'UnsuccessfulOutcome',
        ]
    _set_ = [
        u'RUA-ELEMENTARY-PROCEDURES',
        u'RUA-ELEMENTARY-PROCEDURES-CLASS-1',
        u'RUA-ELEMENTARY-PROCEDURES-CLASS-2',
        ]
    _val_ = [
        u'connectionRequest',
        u'directTransfer',
        u'disconnectRequest',
        u'connectionlessTransfer',
        u'errorIndication',
        u'privateMessage',
        ]
    _class_ = [
        u'RUA-ELEMENTARY-PROCEDURE',
        u'RUA-ELEMENTARY-PROCEDURES',
        u'RUA-ELEMENTARY-PROCEDURES-CLASS-1',
        u'RUA-ELEMENTARY-PROCEDURES-CLASS-2',
        u'connectionRequest',
        u'directTransfer',
        u'disconnectRequest',
        u'connectionlessTransfer',
        u'errorIndication',
        u'privateMessage',
        ]
    _param_ = [
        ]
    
    #-----< RUA-ELEMENTARY-PROCEDURE >-----#
    RUA_ELEMENTARY_PROCEDURE = CLASS(name=u'RUA-ELEMENTARY-PROCEDURE', mode=MODE_TYPE)
    _RUA_ELEMENTARY_PROCEDURE_InitiatingMessage = OPEN(name=u'InitiatingMessage', mode=MODE_TYPE)
    _RUA_ELEMENTARY_PROCEDURE_SuccessfulOutcome = OPEN(name=u'SuccessfulOutcome', mode=MODE_TYPE, opt=True)
    _RUA_ELEMENTARY_PROCEDURE_UnsuccessfulOutcome = OPEN(name=u'UnsuccessfulOutcome', mode=MODE_TYPE, opt=True)
    _RUA_ELEMENTARY_PROCEDURE_procedureCode = INT(name=u'procedureCode', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'ProcedureCode')), uniq=True)
    _RUA_ELEMENTARY_PROCEDURE_criticality = ENUM(name=u'criticality', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-CommonDataTypes', 'Criticality')), default=u'ignore')
    RUA_ELEMENTARY_PROCEDURE._cont = ASN1Dict([
        (u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURE_InitiatingMessage),
        (u'SuccessfulOutcome', _RUA_ELEMENTARY_PROCEDURE_SuccessfulOutcome),
        (u'UnsuccessfulOutcome', _RUA_ELEMENTARY_PROCEDURE_UnsuccessfulOutcome),
        (u'procedureCode', _RUA_ELEMENTARY_PROCEDURE_procedureCode),
        (u'criticality', _RUA_ELEMENTARY_PROCEDURE_criticality),
        ])
    
    #-----< RUA-PDU >-----#
    RUA_PDU = CHOICE(name=u'RUA-PDU', mode=MODE_TYPE)
    _RUA_PDU_initiatingMessage = SEQ(name=u'initiatingMessage', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-PDU-Descriptions', 'InitiatingMessage')))
    _RUA_PDU_successfulOutcome = SEQ(name=u'successfulOutcome', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-PDU-Descriptions', 'SuccessfulOutcome')))
    _RUA_PDU_unsuccessfulOutcome = SEQ(name=u'unsuccessfulOutcome', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RUA-PDU-Descriptions', 'UnsuccessfulOutcome')))
    RUA_PDU._cont = ASN1Dict([
        (u'initiatingMessage', _RUA_PDU_initiatingMessage),
        (u'successfulOutcome', _RUA_PDU_successfulOutcome),
        (u'unsuccessfulOutcome', _RUA_PDU_unsuccessfulOutcome),
        ])
    RUA_PDU._ext = []
    
    #-----< InitiatingMessage >-----#
    InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE)
    _InitiatingMessage_procedureCode = INT(name=u'procedureCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE'), [u'procedureCode']))
    __InitiatingMessage_procedureCode_tab = CLASS(name='_tab_RUA-ELEMENTARY-PROCEDURE', mode=MODE_SET, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_0 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Connect')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_1 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'DirectTransfer')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_2 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Disconnect')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_3 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ConnectionlessTransfer')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_4 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ErrorIndication')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_5 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'PrivateMessage')))
    __InitiatingMessage_procedureCode_tab._val = ASN1Set(rv=[dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_0), (u'procedureCode', 1), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_1), (u'procedureCode', 2), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_2), (u'procedureCode', 3), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_3), (u'procedureCode', 4), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_4), (u'procedureCode', 5), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_5), (u'procedureCode', 6), (u'criticality', u'ignore')])], rr=[], ev=None, er=[])
    _InitiatingMessage_procedureCode._const_tab = __InitiatingMessage_procedureCode_tab
    _InitiatingMessage_procedureCode._const_tab_at = None
    _InitiatingMessage_procedureCode._const_tab_id = u'procedureCode'
    _InitiatingMessage_criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE'), [u'criticality']))
    _InitiatingMessage_criticality._const_tab = __InitiatingMessage_procedureCode_tab
    _InitiatingMessage_criticality._const_tab_at = ('..', u'procedureCode')
    _InitiatingMessage_criticality._const_tab_id = u'criticality'
    _InitiatingMessage_value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE'), [u'InitiatingMessage']))
    _InitiatingMessage_value._const_tab = __InitiatingMessage_procedureCode_tab
    _InitiatingMessage_value._const_tab_at = ('..', u'procedureCode')
    _InitiatingMessage_value._const_tab_id = u'InitiatingMessage'
    InitiatingMessage._cont = ASN1Dict([
        (u'procedureCode', _InitiatingMessage_procedureCode),
        (u'criticality', _InitiatingMessage_criticality),
        (u'value', _InitiatingMessage_value),
        ])
    InitiatingMessage._ext = None
    
    #-----< SuccessfulOutcome >-----#
    SuccessfulOutcome = SEQ(name=u'SuccessfulOutcome', mode=MODE_TYPE)
    _SuccessfulOutcome_procedureCode = INT(name=u'procedureCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE'), [u'procedureCode']))
    __SuccessfulOutcome_procedureCode_tab = CLASS(name='_tab_RUA-ELEMENTARY-PROCEDURE', mode=MODE_SET, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Connect')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'DirectTransfer')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Disconnect')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ConnectionlessTransfer')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ErrorIndication')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'PrivateMessage')))
    __SuccessfulOutcome_procedureCode_tab._val = ASN1Set(rv=[dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0), (u'procedureCode', 1), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1), (u'procedureCode', 2), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2), (u'procedureCode', 3), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3), (u'procedureCode', 4), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4), (u'procedureCode', 5), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5), (u'procedureCode', 6), (u'criticality', u'ignore')])], rr=[], ev=None, er=[])
    _SuccessfulOutcome_procedureCode._const_tab = __SuccessfulOutcome_procedureCode_tab
    _SuccessfulOutcome_procedureCode._const_tab_at = None
    _SuccessfulOutcome_procedureCode._const_tab_id = u'procedureCode'
    _SuccessfulOutcome_criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE'), [u'criticality']))
    _SuccessfulOutcome_criticality._const_tab = __SuccessfulOutcome_procedureCode_tab
    _SuccessfulOutcome_criticality._const_tab_at = ('..', u'procedureCode')
    _SuccessfulOutcome_criticality._const_tab_id = u'criticality'
    _SuccessfulOutcome_value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE'), [u'SuccessfulOutcome']))
    _SuccessfulOutcome_value._const_tab = __SuccessfulOutcome_procedureCode_tab
    _SuccessfulOutcome_value._const_tab_at = ('..', u'procedureCode')
    _SuccessfulOutcome_value._const_tab_id = u'SuccessfulOutcome'
    SuccessfulOutcome._cont = ASN1Dict([
        (u'procedureCode', _SuccessfulOutcome_procedureCode),
        (u'criticality', _SuccessfulOutcome_criticality),
        (u'value', _SuccessfulOutcome_value),
        ])
    SuccessfulOutcome._ext = None
    
    #-----< UnsuccessfulOutcome >-----#
    UnsuccessfulOutcome = SEQ(name=u'UnsuccessfulOutcome', mode=MODE_TYPE)
    _UnsuccessfulOutcome_procedureCode = INT(name=u'procedureCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE'), [u'procedureCode']))
    __UnsuccessfulOutcome_procedureCode_tab = CLASS(name='_tab_RUA-ELEMENTARY-PROCEDURE', mode=MODE_SET, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Connect')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'DirectTransfer')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Disconnect')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ConnectionlessTransfer')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ErrorIndication')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'PrivateMessage')))
    __UnsuccessfulOutcome_procedureCode_tab._val = ASN1Set(rv=[dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0), (u'procedureCode', 1), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1), (u'procedureCode', 2), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2), (u'procedureCode', 3), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3), (u'procedureCode', 4), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4), (u'procedureCode', 5), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5), (u'procedureCode', 6), (u'criticality', u'ignore')])], rr=[], ev=None, er=[])
    _UnsuccessfulOutcome_procedureCode._const_tab = __UnsuccessfulOutcome_procedureCode_tab
    _UnsuccessfulOutcome_procedureCode._const_tab_at = None
    _UnsuccessfulOutcome_procedureCode._const_tab_id = u'procedureCode'
    _UnsuccessfulOutcome_criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE'), [u'criticality']))
    _UnsuccessfulOutcome_criticality._const_tab = __UnsuccessfulOutcome_procedureCode_tab
    _UnsuccessfulOutcome_criticality._const_tab_at = ('..', u'procedureCode')
    _UnsuccessfulOutcome_criticality._const_tab_id = u'criticality'
    _UnsuccessfulOutcome_value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE'), [u'UnsuccessfulOutcome']))
    _UnsuccessfulOutcome_value._const_tab = __UnsuccessfulOutcome_procedureCode_tab
    _UnsuccessfulOutcome_value._const_tab_at = ('..', u'procedureCode')
    _UnsuccessfulOutcome_value._const_tab_id = u'UnsuccessfulOutcome'
    UnsuccessfulOutcome._cont = ASN1Dict([
        (u'procedureCode', _UnsuccessfulOutcome_procedureCode),
        (u'criticality', _UnsuccessfulOutcome_criticality),
        (u'value', _UnsuccessfulOutcome_value),
        ])
    UnsuccessfulOutcome._ext = None
    
    #-----< RUA-ELEMENTARY-PROCEDURES >-----#
    RUA_ELEMENTARY_PROCEDURES = CLASS(name=u'RUA-ELEMENTARY-PROCEDURES', mode=MODE_SET, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_0 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Connect')))
    _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_1 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'DirectTransfer')))
    _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_2 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Disconnect')))
    _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_3 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ConnectionlessTransfer')))
    _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_4 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ErrorIndication')))
    _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_5 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'PrivateMessage')))
    RUA_ELEMENTARY_PROCEDURES._val = ASN1Set(rv=[dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_0), (u'procedureCode', 1), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_1), (u'procedureCode', 2), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_2), (u'procedureCode', 3), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_3), (u'procedureCode', 4), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_4), (u'procedureCode', 5), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_5), (u'procedureCode', 6), (u'criticality', u'ignore')])], rr=[], ev=[], er=[])
    
    #-----< RUA-ELEMENTARY-PROCEDURES-CLASS-1 >-----#
    RUA_ELEMENTARY_PROCEDURES_CLASS_1 = CLASS(name=u'RUA-ELEMENTARY-PROCEDURES-CLASS-1', mode=MODE_SET, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    RUA_ELEMENTARY_PROCEDURES_CLASS_1._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< RUA-ELEMENTARY-PROCEDURES-CLASS-2 >-----#
    RUA_ELEMENTARY_PROCEDURES_CLASS_2 = CLASS(name=u'RUA-ELEMENTARY-PROCEDURES-CLASS-2', mode=MODE_SET, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_0 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Connect')))
    _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_1 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'DirectTransfer')))
    _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_2 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Disconnect')))
    _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_3 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ConnectionlessTransfer')))
    _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_4 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ErrorIndication')))
    _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_5 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'PrivateMessage')))
    RUA_ELEMENTARY_PROCEDURES_CLASS_2._val = ASN1Set(rv=[dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_0), (u'procedureCode', 1), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_1), (u'procedureCode', 2), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_2), (u'procedureCode', 3), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_3), (u'procedureCode', 4), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_4), (u'procedureCode', 5), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_5), (u'procedureCode', 6), (u'criticality', u'ignore')])], rr=[], ev=[], er=[])
    
    #-----< connectionRequest >-----#
    connectionRequest = CLASS(name=u'connectionRequest', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    _connectionRequest_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Connect')))
    connectionRequest._val = dict([(u'InitiatingMessage', _connectionRequest_val_InitiatingMessage), (u'procedureCode', 1), (u'criticality', u'ignore')])
    
    #-----< directTransfer >-----#
    directTransfer = CLASS(name=u'directTransfer', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    _directTransfer_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'DirectTransfer')))
    directTransfer._val = dict([(u'InitiatingMessage', _directTransfer_val_InitiatingMessage), (u'procedureCode', 2), (u'criticality', u'ignore')])
    
    #-----< disconnectRequest >-----#
    disconnectRequest = CLASS(name=u'disconnectRequest', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    _disconnectRequest_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'Disconnect')))
    disconnectRequest._val = dict([(u'InitiatingMessage', _disconnectRequest_val_InitiatingMessage), (u'procedureCode', 3), (u'criticality', u'ignore')])
    
    #-----< connectionlessTransfer >-----#
    connectionlessTransfer = CLASS(name=u'connectionlessTransfer', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    _connectionlessTransfer_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ConnectionlessTransfer')))
    connectionlessTransfer._val = dict([(u'InitiatingMessage', _connectionlessTransfer_val_InitiatingMessage), (u'procedureCode', 4), (u'criticality', u'ignore')])
    
    #-----< errorIndication >-----#
    errorIndication = CLASS(name=u'errorIndication', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    _errorIndication_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'ErrorIndication')))
    errorIndication._val = dict([(u'InitiatingMessage', _errorIndication_val_InitiatingMessage), (u'procedureCode', 5), (u'criticality', u'ignore')])
    
    #-----< privateMessage >-----#
    privateMessage = CLASS(name=u'privateMessage', mode=MODE_VALUE, typeref=ASN1RefType(('RUA-PDU-Descriptions', 'RUA-ELEMENTARY-PROCEDURE')))
    _privateMessage_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RUA-PDU-Contents', 'PrivateMessage')))
    privateMessage._val = dict([(u'InitiatingMessage', _privateMessage_val_InitiatingMessage), (u'procedureCode', 6), (u'criticality', u'ignore')])
    
    _all_ = [
        _RUA_ELEMENTARY_PROCEDURE_InitiatingMessage,
        _RUA_ELEMENTARY_PROCEDURE_SuccessfulOutcome,
        _RUA_ELEMENTARY_PROCEDURE_UnsuccessfulOutcome,
        _RUA_ELEMENTARY_PROCEDURE_procedureCode,
        _RUA_ELEMENTARY_PROCEDURE_criticality,
        RUA_ELEMENTARY_PROCEDURE,
        _RUA_PDU_initiatingMessage,
        _RUA_PDU_successfulOutcome,
        _RUA_PDU_unsuccessfulOutcome,
        RUA_PDU,
        __InitiatingMessage_procedureCode_tab,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_0,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_1,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_2,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_3,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_4,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_5,
        _InitiatingMessage_procedureCode,
        _InitiatingMessage_criticality,
        _InitiatingMessage_value,
        InitiatingMessage,
        __SuccessfulOutcome_procedureCode_tab,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5,
        _SuccessfulOutcome_procedureCode,
        _SuccessfulOutcome_criticality,
        _SuccessfulOutcome_value,
        SuccessfulOutcome,
        __UnsuccessfulOutcome_procedureCode_tab,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5,
        _UnsuccessfulOutcome_procedureCode,
        _UnsuccessfulOutcome_criticality,
        _UnsuccessfulOutcome_value,
        UnsuccessfulOutcome,
        RUA_ELEMENTARY_PROCEDURES,
        _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_0,
        _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_1,
        _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_2,
        _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_3,
        _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_4,
        _RUA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_5,
        RUA_ELEMENTARY_PROCEDURES_CLASS_1,
        RUA_ELEMENTARY_PROCEDURES_CLASS_2,
        _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_0,
        _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_1,
        _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_2,
        _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_3,
        _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_4,
        _RUA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_5,
        connectionRequest,
        _connectionRequest_val_InitiatingMessage,
        directTransfer,
        _directTransfer_val_InitiatingMessage,
        disconnectRequest,
        _disconnectRequest_val_InitiatingMessage,
        connectionlessTransfer,
        _connectionlessTransfer_val_InitiatingMessage,
        errorIndication,
        _errorIndication_val_InitiatingMessage,
        privateMessage,
        _privateMessage_val_InitiatingMessage,
    ]

init_modules(RUA_CommonDataTypes, RUA_Constants, RUA_Containers, RUA_IEs, RUA_PDU_Contents, RUA_PDU_Descriptions)
