package Net::DNS::Resolver::android;

use strict;
use warnings;
our $VERSION = (qw$Id: android.pm 1856 2021-12-02 14:36:25Z willem $)[2];




use base qw(Net::DNS::Resolver::Base);


my $config_file = 'resolv.conf';
my @config_path = ( $ENV{ANDROID_ROOT} || '/system' );
my @config_file = grep { -f $_ && -r _ } map {"$_/etc/$config_file"} @config_path;

my $dotfile = '.resolv.conf';
my @dotpath = grep {defined} $ENV{HOME}, '.';
my @dotfile = grep { -f $_ && -o _ } map {"$_/$dotfile"} @dotpath;


sub _init {
	my $defaults = shift->_defaults;

	my @nameserver;
	for ( 1 .. 4 ) {
		my $ret = `getprop net.dns$_` || next;
		chomp $ret;
		push @nameserver, $ret || next;
	}

	$defaults->nameserver(@nameserver) if @nameserver;


	$defaults->_read_config_file($_) foreach @config_file;

	%$defaults = Net::DNS::Resolver::Base::_untaint(%$defaults);

	$defaults->_read_config_file($_) foreach @dotfile;

	$defaults->_read_env;
	return;
}


1;
__END__



