package Net::DNS::Resolver::UNIX;

use strict;
use warnings;
our $VERSION = (qw$Id: UNIX.pm 1856 2021-12-02 14:36:25Z willem $)[2];




use base qw(Net::DNS::Resolver::Base);


my @config_file = grep { -f $_ && -r _ } '/etc/resolv.conf';

my $dotfile = '.resolv.conf';
my @dotpath = grep {defined} $ENV{HOME}, '.';
my @dotfile = grep { -f $_ && -o _ } map {"$_/$dotfile"} @dotpath;


local $ENV{PATH} = join ':', grep {$_} qw(/bin /usr/bin), $ENV{PATH};
my $uname = eval {`uname -n 2>/dev/null`} || '';
chomp $uname;
my ( $host, @domain ) = split /\./, $uname, 2;
__PACKAGE__->domain(@domain);


sub _init {
	my $defaults = shift->_defaults;

	$defaults->_read_config_file($_) foreach @config_file;

	%$defaults = Net::DNS::Resolver::Base::_untaint(%$defaults);

	$defaults->_read_config_file($_) foreach @dotfile;

	$defaults->_read_env;
	return;
}


1;
__END__



