package Net::DNS::RR::ZONEMD;

use strict;
use warnings;
our $VERSION = (qw$Id: ZONEMD.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Carp;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset ) = @_;

	my $rdata = substr $$data, $offset, $self->{rdlength};
	@{$self}{qw(serial scheme algorithm digestbin)} = unpack 'NC2a*', $rdata;
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	return pack 'NC2a*', @{$self}{qw(serial scheme algorithm digestbin)};
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my @digest = split /(\S{64})/, $self->digest || qq("");
	my @rdata  = ( @{$self}{qw(serial scheme algorithm)}, @digest );
	return @rdata;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->serial(shift);
	$self->scheme(shift);
	$self->algorithm(shift);
	$self->digest(@_);
	return;
}


sub _defaults {				## specify RR attribute default values
	my $self = shift;

	$self->_parse_rdata( 0, 1, 1, '' );
	return;
}


sub serial {
	my $self = shift;

	$self->{serial} = 0 + shift if scalar @_;
	return $self->{serial} || 0;
}


sub scheme {
	my $self = shift;

	$self->{scheme} = 0 + shift if scalar @_;
	return $self->{scheme} || 0;
}


sub algorithm {
	my $self = shift;

	$self->{algorithm} = 0 + shift if scalar @_;
	return $self->{algorithm} || 0;
}


sub digest {
	my $self = shift;
	return unpack "H*", $self->digestbin() unless scalar @_;
	return $self->digestbin( pack "H*", join "", map { /^"*([\dA-Fa-f]*)"*$/ || croak("corrupt hex"); $1 } @_ );
}


sub digestbin {
	my $self = shift;

	$self->{digestbin} = shift if scalar @_;
	return $self->{digestbin} || "";
}


1;
__END__


