package Net::DNS::RR::X25;

use strict;
use warnings;
our $VERSION = (qw$Id: X25.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::Text;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset ) = @_;

	$self->{address} = Net::DNS::Text->decode( $data, $offset );
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	return $self->{address}->encode;
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	return $self->{address}->string;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->address(shift);
	return;
}


sub address {
	my $self = shift;

	$self->{address} = Net::DNS::Text->new(shift) if scalar @_;
	return $self->{address} ? $self->{address}->value : undef;
}


sub PSDNaddress { return &address; }


1;
__END__


