package Net::DNS::RR::SRV;

use strict;
use warnings;
our $VERSION = (qw$Id: SRV.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::DomainName;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset, @opaque ) = @_;

	@{$self}{qw(priority weight port)} = unpack( "\@$offset n3", $$data );

	$self->{target} = Net::DNS::DomainName2535->decode( $data, $offset + 6, @opaque );
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;
	my ( $offset, @opaque ) = @_;

	my $target = $self->{target};
	my @nums   = ( $self->priority, $self->weight, $self->port );
	return pack 'n3 a*', @nums, $target->encode( $offset + 6, @opaque );
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my $target = $self->{target};
	my @rdata  = ( $self->priority, $self->weight, $self->port, $target->string );
	return @rdata;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	foreach my $attr (qw(priority weight port target)) {
		$self->$attr(shift);
	}
	return;
}


sub priority {
	my $self = shift;

	$self->{priority} = 0 + shift if scalar @_;
	return $self->{priority} || 0;
}


sub weight {
	my $self = shift;

	$self->{weight} = 0 + shift if scalar @_;
	return $self->{weight} || 0;
}


sub port {
	my $self = shift;

	$self->{port} = 0 + shift if scalar @_;
	return $self->{port} || 0;
}


sub target {
	my $self = shift;

	$self->{target} = Net::DNS::DomainName2535->new(shift) if scalar @_;
	return $self->{target} ? $self->{target}->name : undef;
}


my $function = sub {
	my ( $a, $b ) = ( $Net::DNS::a, $Net::DNS::b );
	return $a->{priority} <=> $b->{priority}
			|| $b->{weight} <=> $a->{weight};
};

__PACKAGE__->set_rrsort_func( 'priority', $function );

__PACKAGE__->set_rrsort_func( 'default_sort', $function );


1;
__END__


