package Net::DNS::RR::MINFO;

use strict;
use warnings;
our $VERSION = (qw$Id: MINFO.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::Mailbox;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset, @opaque ) = @_;

	( $self->{rmailbx}, $offset ) = Net::DNS::Mailbox1035->decode(@_);
	( $self->{emailbx}, $offset ) = Net::DNS::Mailbox1035->decode( $data, $offset, @opaque );
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;
	my ( $offset, @opaque ) = @_;

	my $rdata = $self->{rmailbx}->encode(@_);
	$rdata .= $self->{emailbx}->encode( $offset + length $rdata, @opaque );
	return $rdata;
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my @rdata = ( $self->{rmailbx}->string, $self->{emailbx}->string );
	return @rdata;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->rmailbx(shift);
	$self->emailbx(shift);
	return;
}


sub rmailbx {
	my $self = shift;

	$self->{rmailbx} = Net::DNS::Mailbox1035->new(shift) if scalar @_;
	return $self->{rmailbx} ? $self->{rmailbx}->address : undef;
}


sub emailbx {
	my $self = shift;

	$self->{emailbx} = Net::DNS::Mailbox1035->new(shift) if scalar @_;
	return $self->{emailbx} ? $self->{emailbx}->address : undef;
}


1;
__END__


