package Net::DNS::RR::MB;

use strict;
use warnings;
our $VERSION = (qw$Id: MB.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::DomainName;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;

	$self->{madname} = Net::DNS::DomainName1035->decode(@_);
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	my $madname = $self->{madname} || return '';
	return $madname->encode(@_);
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my $madname = $self->{madname} || return '';
	return $madname->string;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->madname(shift);
	return;
}


sub madname {
	my $self = shift;

	$self->{madname} = Net::DNS::DomainName1035->new(shift) if scalar @_;
	return $self->{madname} ? $self->{madname}->name : undef;
}


1;
__END__


