package Net::DNS::RR::ISDN;

use strict;
use warnings;
our $VERSION = (qw$Id: ISDN.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::Text;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset ) = @_;

	( $self->{address}, $offset ) = Net::DNS::Text->decode( $data, $offset );
	( $self->{sa},	    $offset ) = Net::DNS::Text->decode( $data, $offset );
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	my $address = $self->{address};
	return join '', $address->encode, $self->{sa}->encode;
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my $address = $self->{address};
	return join ' ', $address->string, $self->{sa}->string;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->address(shift);
	$self->sa(@_);
	return;
}


sub _defaults {				## specify RR attribute default values
	my $self = shift;

	$self->sa('');
	return;
}


sub address {
	my $self = shift;

	$self->{address} = Net::DNS::Text->new(shift) if scalar @_;
	return $self->{address} ? $self->{address}->value : undef;
}


sub sa {
	my $self = shift;

	$self->{sa} = Net::DNS::Text->new(shift) if scalar @_;
	return $self->{sa} ? $self->{sa}->value : undef;
}


sub ISDNaddress { return &address; }


1;
__END__


