package Net::DNS::RR::DHCID;

use strict;
use warnings;
our $VERSION = (qw$Id: DHCID.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use MIME::Base64;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset ) = @_;

	my $size = $self->{rdlength} - 3;
	@{$self}{qw(identifiertype digesttype digest)} = unpack "\@$offset nC a$size", $$data;
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	return pack 'nC a*', map { $self->$_ } qw(identifiertype digesttype digest);
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my @rdata = split /\s+/, encode_base64( $self->_encode_rdata );
	return @rdata;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	my $data = MIME::Base64::decode( join "", @_ );
	my $size = length($data) - 3;
	@{$self}{qw(identifiertype digesttype digest)} = unpack "n C a$size", $data;
	return;
}




sub identifiertype {
	my $self = shift;

	$self->{identifiertype} = 0 + shift if scalar @_;
	return $self->{identifiertype} || 0;
}


sub digesttype {
	my $self = shift;

	$self->{digesttype} = 0 + shift if scalar @_;
	return $self->{digesttype} || 0;
}


sub digest {
	my $self = shift;

	$self->{digest} = shift if scalar @_;
	return $self->{digest} || "";
}


1;
__END__


