package Net::DNS::RR::CSYNC;

use strict;
use warnings;
our $VERSION = (qw$Id: CSYNC.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::RR::NSEC;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset ) = @_;

	my $limit = $offset + $self->{rdlength};
	@{$self}{qw(soaserial flags)} = unpack "\@$offset Nn", $$data;
	$offset += 6;
	$self->{typebm} = substr $$data, $offset, $limit - $offset;
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	return pack 'N n a*', $self->soaserial, $self->flags, $self->{typebm};
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my @rdata = ( $self->soaserial, $self->flags, $self->typelist );
	return @rdata;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->soaserial(shift);
	$self->flags(shift);
	$self->typelist(@_);
	return;
}


sub soaserial {
	my $self = shift;

	$self->{soaserial} = 0 + shift if scalar @_;
	return $self->{soaserial} || 0;
}


sub flags {
	my $self = shift;

	$self->{flags} = 0 + shift if scalar @_;
	return $self->{flags} || 0;
}


sub immediate {
	my $self = shift;
	if ( scalar @_ ) {
		for ( $self->{flags} ) {
			$_ = 0x0001 | ( $_ || 0 );
			$_ ^= 0x0001 unless shift;
		}
	}
	return 0x0001 & ( $self->{flags} || 0 );
}


sub soaminimum {
	my $self = shift;
	if ( scalar @_ ) {
		for ( $self->{flags} ) {
			$_ = 0x0002 | ( $_ || 0 );
			$_ ^= 0x0002 unless shift;
		}
	}
	return 0x0002 & ( $self->{flags} || 0 );
}


sub typelist {
	return &Net::DNS::RR::NSEC::typelist;
}


1;
__END__


