package Net::DNS::Mailbox;

use strict;
use warnings;

our $VERSION = (qw$Id: Mailbox.pm 1855 2021-11-26 11:33:48Z willem $)[2];




use integer;
use Carp;

use base qw(Net::DNS::DomainName);



sub new {
	my $class = shift;
	local $_ = shift;
	croak 'undefined mail address' unless defined $_;

	s/^.*<//g;						# strip excess on left
	s/>.*$//g;						# strip excess on right

	s/\\\@/\\064/g;						# disguise escaped @
	s/("[^"]*)\@([^"]*")/$1\\064$2/g;			# disguise quoted @

	my ( $mbox, @host ) = split /\@/;			# split on @ if present
	for ( $mbox ||= '' ) {
		s/^.*"(.*)".*$/$1/;				# strip quotes
		s/\\\./\\046/g;					# disguise escaped dot
		s/\./\\046/g if @host;				# escape dots in local part
	}

	return bless __PACKAGE__->SUPER::new( join '.', $mbox, @host ), $class;
}



sub address {
	return unless defined wantarray;
	my @label = shift->label;
	local $_ = shift(@label) || return '<>';
	s/\\\\//g;						# delete escaped \
	s/\\\d\d\d//g;						# delete non-printable
	s/\\\./\./g;						# unescape dots
	s/[\\"]//g;						# delete \ "
	s/^(.*)$/"$1"/ if /["(),:;<>@\[\\\]]/;			# quote local part
	return $_ unless scalar(@label);
	return join '@', $_, join '.', @label;
}



package Net::DNS::Mailbox1035;		## no critic ProhibitMultiplePackages
our @ISA = qw(Net::DNS::Mailbox);

sub encode { return &Net::DNS::DomainName1035::encode; }


package Net::DNS::Mailbox2535;		## no critic ProhibitMultiplePackages
our @ISA = qw(Net::DNS::Mailbox);

sub encode { return &Net::DNS::DomainName2535::encode; }


1;
__END__




