package Net::DNS;

use strict;
use warnings;

our $VERSION;
$VERSION = '1.35';
$VERSION = eval { $VERSION };
our $SVNVERSION = (qw$Id: DNS.pm 1882 2022-10-04 19:53:44Z willem $)[2];




use integer;

use base qw(Exporter);
our @EXPORT = qw(SEQUENTIAL UNIXTIME YYYYMMDDxx
		yxrrset nxrrset yxdomain nxdomain rr_add rr_del
		mx rr rrsort);


local $SIG{__DIE__};
require Net::DNS::Resolver;
require Net::DNS::Packet;
require Net::DNS::RR;
require Net::DNS::Update;


sub version { return $VERSION; }


sub rr {
	my ($arg1) = @_;
	my $res = ref($arg1) ? shift : Net::DNS::Resolver->new();

	my $reply = $res->query(@_);
	my @list  = $reply ? $reply->answer : ();
	return @list;
}


sub mx {
	my ($arg1) = @_;
	my @res = ( ref($arg1) ? shift : () );
	my ( $name, @class ) = @_;

	# This construct is best read backwards.
	#
	# First we take the answer section of the packet.
	# Then we take just the MX records from that list
	# Then we sort the list by preference
	# We do this into an array to force list context.
	# Then we return the list.

	my @list = sort { $a->preference <=> $b->preference }
			grep { $_->type eq 'MX' } &rr( @res, $name, 'MX', @class );
	return @list;
}


sub rrsort {
	my $rrtype = uc shift;
	my ( $attribute, @rr ) = @_;	## NB: attribute is optional
	( @rr, $attribute ) = @_ if ref($attribute) =~ /^Net::DNS::RR/;

	my @extracted = grep { $_->type eq $rrtype } @rr;
	return @extracted unless scalar @extracted;
	my $func   = "Net::DNS::RR::$rrtype"->get_rrsort_func($attribute);
	my @sorted = sort $func @extracted;
	return @sorted;
}



sub SEQUENTIAL { return (undef) }

sub UNIXTIME { return CORE::time; }

sub YYYYMMDDxx {
	my ( $dd, $mm, $yy ) = (localtime)[3 .. 5];
	return 1900010000 + sprintf '%d%0.2d%0.2d00', $yy, $mm, $dd;
}



sub yxrrset {
	my $rr = Net::DNS::RR->new(@_);
	$rr->ttl(0);
	$rr->class('ANY') unless $rr->rdata;
	return $rr;
}

sub nxrrset {
	my $rr = Net::DNS::RR->new(@_);
	return Net::DNS::RR->new(
		name  => $rr->name,
		type  => $rr->type,
		class => 'NONE'
		);
}

sub yxdomain {
	my ( $domain, @etc ) = map {split} @_;
	my $rr = Net::DNS::RR->new( scalar(@etc) ? @_ : ( name => $domain ) );
	return Net::DNS::RR->new(
		name  => $rr->name,
		type  => 'ANY',
		class => 'ANY'
		);
}

sub nxdomain {
	my ( $domain, @etc ) = map {split} @_;
	my $rr = Net::DNS::RR->new( scalar(@etc) ? @_ : ( name => $domain ) );
	return Net::DNS::RR->new(
		name  => $rr->name,
		type  => 'ANY',
		class => 'NONE'
		);
}

sub rr_add {
	my $rr = Net::DNS::RR->new(@_);
	$rr->{ttl} = 86400 unless defined $rr->{ttl};
	return $rr;
}

sub rr_del {
	my ( $domain, @etc ) = map {split} @_;
	my $rr = Net::DNS::RR->new( scalar(@etc) ? @_ : ( name => $domain, type => 'ANY' ) );
	$rr->class( $rr->rdata ? 'NONE' : 'ANY' );
	$rr->ttl(0);
	return $rr;
}


1;
__END__




