package Net::DNS::Update;

use strict;
use warnings;

our $VERSION = (qw$Id: Update.pm 1855 2021-11-26 11:33:48Z willem $)[2];




use integer;
use Carp;

use base qw(Net::DNS::Packet);

use Net::DNS::Resolver;



sub new {
	my ( $class, $zone, @rrclass ) = @_;

	my ($domain) = grep { defined && length } ( $zone, Net::DNS::Resolver->searchlist );

	my $self = __PACKAGE__->SUPER::new( $domain, 'SOA', @rrclass );

	my $header = $self->header;
	$header->opcode('UPDATE');
	$header->qr(0);
	$header->rd(0);

	return $self;
}



sub push {
	my $self = shift;
	my $list = $self->_section(shift);
	my @arg	 = grep { ref($_) } @_;

	my ($zone) = $self->zone;
	my $zclass = $zone->zclass;
	my @rr = grep { $_->class( $_->class =~ /ANY|NONE/ ? () : $zclass ) } @arg;

	return CORE::push( @$list, @rr );
}



sub unique_push {
	my $self = shift;
	my $list = $self->_section(shift);
	my @arg	 = grep { ref($_) } @_;

	my ($zone) = $self->zone;
	my $zclass = $zone->zclass;
	my @rr = grep { $_->class( $_->class =~ /ANY|NONE/ ? () : $zclass ) } @arg;

	my %unique = map { ( bless( {%$_, ttl => 0}, ref $_ )->canonical => $_ ) } ( @rr, @$list );

	return scalar( @$list = values %unique );
}


1;

__END__



