package Net::DNS::RR::URI;

use strict;
use warnings;
our $VERSION = (qw$Id: URI.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::Text;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset ) = @_;

	my $limit = $offset + $self->{rdlength};
	@{$self}{qw(priority weight)} = unpack( "\@$offset n2", $$data );
	$offset += 4;
	$self->{target} = Net::DNS::Text->decode( $data, $offset, $limit - $offset );
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	my $target = $self->{target};
	return pack 'n2 a*', @{$self}{qw(priority weight)}, $target->raw;
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my $target = $self->{target};
	my @rdata  = ( $self->priority, $self->weight, $target->string );
	return @rdata;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->$_(shift) foreach qw(priority weight target);
	return;
}


sub priority {
	my $self = shift;

	$self->{priority} = 0 + shift if scalar @_;
	return $self->{priority} || 0;
}


sub weight {
	my $self = shift;

	$self->{weight} = 0 + shift if scalar @_;
	return $self->{weight} || 0;
}


sub target {
	my $self = shift;

	$self->{target} = Net::DNS::Text->new(shift) if scalar @_;
	return $self->{target} ? $self->{target}->value : undef;
}


my $function = sub {
	my ( $a, $b ) = ( $Net::DNS::a, $Net::DNS::b );
	return $a->{priority} <=> $b->{priority}
			|| $b->{weight} <=> $a->{weight};
};

__PACKAGE__->set_rrsort_func( 'priority', $function );

__PACKAGE__->set_rrsort_func( 'default_sort', $function );


1;
__END__


