package Net::DNS::RR::TXT;

use strict;
use warnings;
our $VERSION = (qw$Id: TXT.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);


use integer;

use Carp;
use Net::DNS::Text;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset ) = @_;

	my $limit = $offset + $self->{rdlength};
	my $text;
	my $txtdata = $self->{txtdata} = [];
	while ( $offset < $limit ) {
		( $text, $offset ) = Net::DNS::Text->decode( $data, $offset );
		push @$txtdata, $text;
	}

	croak('corrupt TXT data') unless $offset == $limit;	# more or less FUBAR
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	my $txtdata = $self->{txtdata};
	return join '', map { $_->encode } @$txtdata;
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my $txtdata = $self->{txtdata};
	return ( map { $_->unicode } @$txtdata );
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->{txtdata} = [map { Net::DNS::Text->new($_) } @_];
	return;
}


sub txtdata {
	my $self = shift;

	$self->{txtdata} = [map { Net::DNS::Text->new($_) } @_] if scalar @_;

	my $txtdata = $self->{txtdata} || [];

	return ( map { $_->value } @$txtdata ) if wantarray;

	return defined(wantarray) ? join( ' ', map { $_->value } @$txtdata ) : '';
}


sub char_str_list { return (&txtdata); }			# uncoverable pod


1;
__END__


