package Net::DNS::RR::RP;

use strict;
use warnings;
our $VERSION = (qw$Id: RP.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::DomainName;
use Net::DNS::Mailbox;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset, @opaque ) = @_;

	( $self->{mbox}, $offset ) = Net::DNS::Mailbox2535->decode( $data, $offset, @opaque );
	$self->{txtdname} = Net::DNS::DomainName2535->decode( $data, $offset, @opaque );
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;
	my ( $offset, @opaque ) = @_;

	my $txtdname = $self->{txtdname};
	my $rdata    = $self->{mbox}->encode( $offset, @opaque );
	$rdata .= $txtdname->encode( $offset + length($rdata), @opaque );
	return $rdata;
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my @rdata = ( $self->{mbox}->string, $self->{txtdname}->string );
	return @rdata;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->mbox(shift);
	$self->txtdname(shift);
	return;
}


sub mbox {
	my $self = shift;

	$self->{mbox} = Net::DNS::Mailbox2535->new(shift) if scalar @_;
	return $self->{mbox} ? $self->{mbox}->address : undef;
}


sub txtdname {
	my $self = shift;

	$self->{txtdname} = Net::DNS::DomainName2535->new(shift) if scalar @_;
	return $self->{txtdname} ? $self->{txtdname}->name : undef;
}


1;
__END__


