package Net::DNS::RR::PX;

use strict;
use warnings;
our $VERSION = (qw$Id: PX.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::DomainName;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset, @opaque ) = @_;

	$self->{preference} = unpack( "\@$offset n", $$data );
	( $self->{map822},  $offset ) = Net::DNS::DomainName2535->decode( $data, $offset + 2, @opaque );
	( $self->{mapx400}, $offset ) = Net::DNS::DomainName2535->decode( $data, $offset + 0, @opaque );
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;
	my ( $offset, @opaque ) = @_;

	my $mapx400 = $self->{mapx400};
	my $rdata   = pack( 'n', $self->{preference} );
	$rdata .= $self->{map822}->encode( $offset + 2, @opaque );
	$rdata .= $mapx400->encode( $offset + length($rdata), @opaque );
	return $rdata;
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my @rdata = ( $self->preference, $self->{map822}->string, $self->{mapx400}->string );
	return @rdata;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->preference(shift);
	$self->map822(shift);
	$self->mapx400(shift);
	return;
}


sub preference {
	my $self = shift;

	$self->{preference} = 0 + shift if scalar @_;
	return $self->{preference} || 0;
}


sub map822 {
	my $self = shift;

	$self->{map822} = Net::DNS::DomainName2535->new(shift) if scalar @_;
	return $self->{map822} ? $self->{map822}->name : undef;
}


sub mapx400 {
	my $self = shift;

	$self->{mapx400} = Net::DNS::DomainName2535->new(shift) if scalar @_;
	return $self->{mapx400} ? $self->{mapx400}->name : undef;
}


my $function = sub {			## sort RRs in numerically ascending order.
	return $Net::DNS::a->{'preference'} <=> $Net::DNS::b->{'preference'};
};

__PACKAGE__->set_rrsort_func( 'preference', $function );

__PACKAGE__->set_rrsort_func( 'default_sort', $function );


1;
__END__


