package Net::DNS::RR::NS;

use strict;
use warnings;
our $VERSION = (qw$Id: NS.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::DomainName;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;

	$self->{nsdname} = Net::DNS::DomainName1035->decode(@_);
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	my $nsdname = $self->{nsdname};
	return $nsdname->encode(@_);
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my $nsdname = $self->{nsdname};
	return $nsdname->string;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->nsdname(shift);
	return;
}


sub nsdname {
	my $self = shift;

	$self->{nsdname} = Net::DNS::DomainName1035->new(shift) if scalar @_;
	return $self->{nsdname} ? $self->{nsdname}->name : undef;
}


1;
__END__


