package Net::DNS::RR::MG;

use strict;
use warnings;
our $VERSION = (qw$Id: MG.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::DomainName;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;

	$self->{mgmname} = Net::DNS::DomainName1035->decode(@_);
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	my $mgmname = $self->{mgmname} || return '';
	return $mgmname->encode(@_);
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my $mgmname = $self->{mgmname} || return '';
	return $mgmname->string;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->mgmname(shift);
	return;
}


sub mgmname {
	my $self = shift;

	$self->{mgmname} = Net::DNS::DomainName1035->new(shift) if scalar @_;
	return $self->{mgmname} ? $self->{mgmname}->name : undef;
}


1;
__END__


