package Net::DNS::RR::HINFO;

use strict;
use warnings;
our $VERSION = (qw$Id: HINFO.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::Text;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset ) = @_;

	( $self->{cpu}, $offset ) = Net::DNS::Text->decode( $data, $offset );
	( $self->{os},	$offset ) = Net::DNS::Text->decode( $data, $offset );
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	return join '', $self->{cpu}->encode, $self->{os}->encode;
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	return join ' ', $self->{cpu}->string, $self->{os}->string;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->cpu(shift);
	$self->os(@_);
	return;
}


sub cpu {
	my $self = shift;

	$self->{cpu} = Net::DNS::Text->new(shift) if scalar @_;
	return $self->{cpu} ? $self->{cpu}->value : undef;
}


sub os {
	my $self = shift;

	$self->{os} = Net::DNS::Text->new(shift) if scalar @_;
	return $self->{os} ? $self->{os}->value : undef;
}


1;
__END__


