package Net::DNS::RR::DNAME;

use strict;
use warnings;
our $VERSION = (qw$Id: DNAME.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::DomainName;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;

	$self->{target} = Net::DNS::DomainName2535->decode(@_);
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	my $target = $self->{target};
	return $target->encode(@_);
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my $target = $self->{target};
	return $target->string;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->target(shift);
	return;
}


sub target {
	my $self = shift;

	$self->{target} = Net::DNS::DomainName2535->new(shift) if scalar @_;
	return $self->{target} ? $self->{target}->name : undef;
}


sub dname { return &target; }					# uncoverable pod


1;
__END__


