package Net::DNS::RR::CDS;

use strict;
use warnings;
our $VERSION = (qw$Id: CDS.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR::DS);



use integer;


sub algorithm {
	my ( $self, $arg ) = @_;
	return $self->SUPER::algorithm($arg) if $arg;
	return $self->SUPER::algorithm() unless defined $arg;
	@{$self}{qw(keytag algorithm digtype)} = ( 0, 0, 0 );
	return;
}


sub digtype {
	my ( $self, $arg ) = @_;
	return $self->SUPER::digtype( $arg ? $arg : () );
}


sub digest {
	my $self = shift;
	return $self->SUPER::digest(@_) unless defined( $_[0] ) && length( $_[0] ) < 2;
	return $self->SUPER::digestbin( $_[0] ? '' : chr(0) );
}


1;
__END__


