package Net::DNS::RR::CAA;

use strict;
use warnings;
our $VERSION = (qw$Id: CAA.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::Text;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset ) = @_;

	my $limit = $offset + $self->{rdlength};
	$self->{flags} = unpack "\@$offset C", $$data;
	( $self->{tag}, $offset ) = Net::DNS::Text->decode( $data, $offset + 1 );
	$self->{value} = Net::DNS::Text->decode( $data, $offset, $limit - $offset );
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	return pack 'C a* a*', $self->flags, $self->{tag}->encode, $self->{value}->raw;
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my @rdata = ( $self->flags, $self->{tag}->string, $self->{value}->string );
	return @rdata;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->flags(shift);
	$self->tag( lc shift );
	$self->value(shift);
	return;
}


sub _defaults {				## specify RR attribute default values
	my $self = shift;

	$self->flags(0);
	return;
}


sub flags {
	my $self = shift;

	$self->{flags} = 0 + shift if scalar @_;
	return $self->{flags} || 0;
}


sub critical {
	my $self = shift;
	if ( scalar @_ ) {
		for ( $self->{flags} ) {
			$_ = 0x0080 | ( $_ || 0 );
			$_ ^= 0x0080 unless shift;
		}
	}
	return 0x0080 & ( $self->{flags} || 0 );
}


sub tag {
	my $self = shift;

	$self->{tag} = Net::DNS::Text->new(shift) if scalar @_;
	return $self->{tag} ? $self->{tag}->value : undef;
}


sub value {
	my $self = shift;

	$self->{value} = Net::DNS::Text->new(shift) if scalar @_;
	return $self->{value} ? $self->{value}->value : undef;
}


1;
__END__


