package Net::DNS::RR::AFSDB;

use strict;
use warnings;
our $VERSION = (qw$Id: AFSDB.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;

use Net::DNS::DomainName;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset, @opaque ) = @_;

	$self->{subtype}  = unpack "\@$offset n", $$data;
	$self->{hostname} = Net::DNS::DomainName2535->decode( $data, $offset + 2, @opaque );
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;
	my ( $offset, @opaque ) = @_;

	my $hostname = $self->{hostname};
	return pack 'n a*', $self->subtype, $hostname->encode( $offset + 2, @opaque );
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	my $hostname = $self->{hostname};
	return join ' ', $self->subtype, $hostname->string;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->subtype(shift);
	$self->hostname(shift);
	return;
}


sub subtype {
	my $self = shift;

	$self->{subtype} = 0 + shift if scalar @_;
	return $self->{subtype} || 0;
}


sub hostname {
	my $self = shift;

	$self->{hostname} = Net::DNS::DomainName2535->new(shift) if scalar @_;
	return $self->{hostname} ? $self->{hostname}->name : undef;
}


1;
__END__


