package Net::DNS::RR::A;

use strict;
use warnings;
our $VERSION = (qw$Id: A.pm 1857 2021-12-07 13:38:02Z willem $)[2];

use base qw(Net::DNS::RR);



use integer;


sub _decode_rdata {			## decode rdata from wire-format octet string
	my $self = shift;
	my ( $data, $offset ) = @_;

	$self->{address} = unpack "\@$offset a4", $$data;
	return;
}


sub _encode_rdata {			## encode rdata as wire-format octet string
	my $self = shift;

	return pack 'a4', $self->{address};
}


sub _format_rdata {			## format rdata portion of RR string.
	my $self = shift;

	return $self->address;
}


sub _parse_rdata {			## populate RR from rdata in argument list
	my $self = shift;

	$self->address(shift);
	return;
}


my $pad = pack 'x4';

sub address {
	my ( $self, $addr ) = @_;

	return join '.', unpack 'C4', $self->{address} . $pad unless defined $addr;

	# Note: pack masks overlarge values, mostly without warning
	my @part = split /\./, $addr;
	my $last = pop(@part);
	return $self->{address} = pack 'C4', @part, (0) x ( 3 - @part ), $last;
}


1;
__END__


