"use strict";

var _PhoneNumberMatcher = _interopRequireDefault(require("./PhoneNumberMatcher.js"));
var _metadataMin = _interopRequireDefault(require("../metadata.min.json"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function test(text, defaultCountry, expectedNumbers) {
  if (typeof expectedNumbers === 'string') {
    expectedNumbers = [{
      nationalNumber: expectedNumbers
    }];
  }
  var matcher = new _PhoneNumberMatcher["default"](text, {
    defaultCountry: defaultCountry,
    v2: true
  }, _metadataMin["default"]);
  while (matcher.hasNext()) {
    var number = matcher.next();
    var phoneNumber = expectedNumbers.shift();
    if (phoneNumber.startsAt !== undefined) {
      expect(number.startsAt).to.equal(phoneNumber.startsAt);
    }
    if (phoneNumber.endsAt !== undefined) {
      expect(number.endsAt).to.equal(phoneNumber.endsAt);
    }
    expect(number.number.country).to.equal(phoneNumber.country || defaultCountry);
    expect(number.number.nationalNumber).to.equal(phoneNumber.nationalNumber);
  }
  expect(expectedNumbers.length).to.equal(0);
}
describe('PhoneNumberMatcher', function () {
  it('should find phone numbers', function () {
    test('The number is +7 (800) 555-35-35 and not (213) 373-4253 as written in the document.', 'US', [{
      country: 'RU',
      nationalNumber: '8005553535',
      startsAt: 14,
      endsAt: 32
    }, {
      country: 'US',
      nationalNumber: '2133734253',
      startsAt: 41,
      endsAt: 55
    }]);
  });
  it('should find phone numbers from Mexico', function () {
    // Test parsing fixed-line numbers of Mexico.
    test('+52 (449)978-0001', 'MX', '4499780001');
    test('01 (449)978-0001', 'MX', '4499780001');
    test('(449)978-0001', 'MX', '4499780001');

    // "Dialling tokens 01, 02, 044, 045 and 1 are removed as they are
    //  no longer valid since August 2019."
    // // Test parsing mobile numbers of Mexico.
    // test('+52 1 33 1234-5678', 'MX', '3312345678')
    // test('044 (33) 1234-5678', 'MX', '3312345678')
    // test('045 33 1234-5678', 'MX', '3312345678')
  });
  it('should find phone numbers from Argentina', function () {
    // Test parsing mobile numbers of Argentina.
    test('+54 9 343 555 1212', 'AR', '93435551212');
    test('0343 15-555-1212', 'AR', '93435551212');
    test('+54 9 3715 65 4320', 'AR', '93715654320');
    test('03715 15 65 4320', 'AR', '93715654320');

    // Test parsing fixed-line numbers of Argentina.
    test('+54 11 3797 0000', 'AR', '1137970000');
    test('011 3797 0000', 'AR', '1137970000');
    test('+54 3715 65 4321', 'AR', '3715654321');
    test('03715 65 4321', 'AR', '3715654321');
    test('+54 23 1234 0000', 'AR', '2312340000');
    test('023 1234 0000', 'AR', '2312340000');
  });
  it('should only support the supported leniency values', function () {
    expect(function () {
      return new _PhoneNumberMatcher["default"]('+54 23 1234 0000', {
        leniency: 'STRICT_GROUPING',
        v2: true
      }, _metadataMin["default"]);
    }).to["throw"]('Supported values: "POSSIBLE", "VALID".');
  });
  it('should validate input parameters', function () {
    // expect(() => new PhoneNumberMatcher('+54 23 1234 0000', { v2: true }, metadata)).to.throw('`leniency` is required')
    expect(function () {
      return new _PhoneNumberMatcher["default"]('+54 23 1234 0000', {
        leniency: '???',
        v2: true
      }, _metadataMin["default"]);
    }).to["throw"]('Unknown leniency: "???"');
    expect(function () {
      return new _PhoneNumberMatcher["default"]('+54 23 1234 0000', {
        maxTries: -1,
        v2: true
      }, _metadataMin["default"]);
    }).to["throw"]('`maxTries` must be `>= 0`');
  });
  it('should throw when calling `.next()` and there\'s no next match', function () {
    var matcher = new _PhoneNumberMatcher["default"]('+54 23 1234 0000', {
      v2: true
    }, _metadataMin["default"]);
    matcher.next();
    expect(function () {
      return matcher.next();
    }).to["throw"]('No next element');
  });
});
//# sourceMappingURL=PhoneNumberMatcher.test.js.map