package autodie::Util;

use strict;
use warnings;

use Exporter 5.57 qw(import);

use autodie::Scope::GuardStack;

our @EXPORT_OK = qw(
  fill_protos
  install_subs
  make_core_trampoline
  on_end_of_compile_scope
);

our $VERSION = '2.29'; # VERSION: Generated by DZP::OurPkg:Version


my $H_STACK_KEY = __PACKAGE__ . '/stack';

sub on_end_of_compile_scope {
    my ($hook) = @_;

    # Dark magic to have autodie work under 5.8
    # Copied from namespace::clean, that copied it from
    # autobox, that found it on an ancient scroll written
    # in blood.

    # This magic bit causes %^H to be lexically scoped.
    $^H |= 0x020000;

    my $stack = $^H{$H_STACK_KEY};
    if (not defined($stack)) {
        $stack = autodie::Scope::GuardStack->new;
        $^H{$H_STACK_KEY} = $stack;
    }

    $stack->push_hook($hook);
    return;
}

sub fill_protos {
    my ($proto) = @_;
    my ($n, $isref, @out, @out1, $seen_semi) = -1;
    if ($proto =~ m{^\s* (?: [;] \s*)? \@}x) {
        # prototype is entirely slurply - special case that does not
        # require any handling.
        return ([0, '@_']);
    }

    while ($proto =~ /\S/) {
        $n++;
        push(@out1,[$n,@out]) if $seen_semi;
        push(@out, $1 . "{\$_[$n]}"), next if $proto =~ s/^\s*\\([\@%\$\&])//;
        push(@out, "\$_[$n]"),        next if $proto =~ s/^\s*([_*\$&])//;
        push(@out, "\@_[$n..\$#_]"),  last if $proto =~ s/^\s*(;\s*)?\@//;
        $seen_semi = 1, $n--,         next if $proto =~ s/^\s*;//; # XXXX ????
        die "Internal error: Unknown prototype letters: \"$proto\"";
    }
    push(@out1,[$n+1,@out]);
    return @out1;
}


sub make_core_trampoline {
    my ($call, $pkg, $proto_str) = @_;
    my $trampoline_code = 'sub {';
    my $trampoline_sub;
    my @protos = fill_protos($proto_str);

    foreach my $proto (@protos) {
        local $" = ", ";    # So @args is formatted correctly.
        my ($count, @args) = @$proto;
        if (@args && $args[-1] =~ m/[@#]_/) {
            $trampoline_code .= qq/
                if (\@_ >= $count) {
                    return $call(@args);
                }
             /;
        } else {
            $trampoline_code .= qq<
                if (\@_ == $count) {
                    return $call(@args);
                }
             >;
        }
    }

    $trampoline_code .= qq< require Carp; Carp::croak("Internal error in Fatal/autodie.  Leak-guard failure"); } >;
    my $E;

    {
        local $@;
        $trampoline_sub = eval "package $pkg;\n $trampoline_code"; ## no critic
        $E = $@;
    }
    die "Internal error in Fatal/autodie: Leak-guard installation failure: $E"
        if $E;

    return $trampoline_sub;
}


sub install_subs {
    my ($target_pkg, $subs_to_reinstate) = @_;

    my $pkg_sym = "${target_pkg}::";

    # It does not hurt to do this in a predictable order, and might help debugging.
    foreach my $sub_name (sort keys(%{$subs_to_reinstate})) {

        # We will repeatedly mess with stuff that strict "refs" does
        # not like.  So lets just disable it once for this entire
        # scope.
        no strict qw(refs);   ## no critic

        my $sub_ref = $subs_to_reinstate->{$sub_name};

        my $full_path = ${pkg_sym}.${sub_name};
        my $oldglob = *$full_path;

        # Nuke the old glob.
        delete($pkg_sym->{$sub_name});

        # For some reason this local *alias = *$full_path triggers an
        # "only used once" warning.  Not entirely sure why, but at
        # least it is easy to silence.
        no warnings qw(once);
        local *alias = *$full_path;
        use warnings qw(once);

        # Copy innocent bystanders back.  Note that we lose
        # formats; it seems that Perl versions up to 5.10.0
        # have a bug which causes copying formats to end up in
        # the scalar slot.  Thanks to Ben Morrow for spotting this.

        foreach my $slot (qw( SCALAR ARRAY HASH IO ) ) {
            next unless defined(*$oldglob{$slot});
            *alias = *$oldglob{$slot};
        }

        if ($sub_ref) {
            *$full_path = $sub_ref;
        }
    }

    return;
}

1;

__END__

