# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/si2n_rest_octets.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 10.5.2.33c SI 2n Rest Octets
# top-level object: SI2n Rest Octets



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

gprs_support_indicator_struct = CSN1Alt(name='gprs_support_indicator_struct', alt={
  '0': ('', []),
  '1': ('', [
  CSN1Bit(name='same_ra_as_serving_cell'),
  CSN1Bit(name='si13_position')])})

gsm_neighbour_cell_selection_params_struct = CSN1List(name='gsm_neighbour_cell_selection_params_struct', list=[
  CSN1Bit(name='ncell_list_index', bit=6),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='bsic', bit=6)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='cell_bar_access'),
    CSN1Bit(name='same_la_as_serving_cell'),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='rxlev_access_min', bit=6),
      CSN1Bit(name='ms_txpwr_max_cch', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='cbq'),
      CSN1Bit(name='cell_reselect_offset', bit=6),
      CSN1Bit(name='temporary_offset', bit=3),
      CSN1Bit(name='penalty_time', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='power_offset', bit=2)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='gprs_support_indicator', obj=gprs_support_indicator_struct)])})])})])

si2n_rest_octets = CSN1List(name='si2n_rest_octets', list=[
  CSN1Bit(name='ba_ind'),
  CSN1Bit(name='si2n_change_mark', bit=2),
  CSN1Bit(name='si2n_index', bit=4),
  CSN1Bit(name='si2n_count', bit=4),
  CSN1List(name='gsm_neighbour_cell_selection_parameters', list=[
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(obj=gsm_neighbour_cell_selection_params_struct)]),
    CSN1Val(name='', val='0')]),
  CSN1Ref(obj=spare_padding)])

