# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/packet_channel_request_11_bit_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.5 Packet Channel Request
# top-level object: Packet channel request 11 bit message content



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

packet_channel_request_11_bit_message_content = CSN1Alt(name='packet_channel_request_11_bit_message_content', alt={
  '0': ('one_phase_access_request', [
  CSN1Bit(name='multislotclass', bit=5),
  CSN1Bit(name='priority', bit=2),
  CSN1Bit(name='randombits', bit=3)]),
  '100': ('short_access_request', [
  CSN1Bit(name='numberofblocks', bit=3),
  CSN1Bit(name='priority', bit=2),
  CSN1Bit(name='randombits', bit=3)]),
  '110000': ('two_phase_access_request', [
  CSN1Bit(name='priority', bit=2),
  CSN1Bit(name='randombits', bit=3)]),
  '110001': ('page_response', [
  CSN1Bit(name='randombits', bit=5)]),
  '110010': ('cell_update', [
  CSN1Bit(name='randombits', bit=5)]),
  '110011': ('mm_procedure', [
  CSN1Bit(name='randombits', bit=5)]),
  '110100': ('single_block_without_tbf_establishment', [
  CSN1Bit(name='randombits', bit=5)]),
  '110101': ('one_phase_access_request_in_rlc_unack_mode', [
  CSN1Bit(name='randombits', bit=5)]),
  '110110': ('dedicated_channel_request', [
  CSN1Bit(name='randombits', bit=5)]),
  '110111': ('emergency_call', [
  CSN1Bit(name='randombits', bit=5)]),
  '111000': ('single_block_mbms_access', [
  CSN1Bit(name='randombits', bit=5)])})

packet_channel_request_8_bit_message_content = CSN1Alt(name='packet_channel_request_8_bit_message_content', alt={
  '00': ('short_access_request', [
  CSN1Bit(name='numberofblocks', bit=3),
  CSN1Bit(name='randombits', bit=3)]),
  '01000': ('two_phase_access_request', [
  CSN1Bit(name='randombits', bit=3)]),
  '01001': ('page_response', [
  CSN1Bit(name='randombits', bit=3)]),
  '01010': ('cell_update', [
  CSN1Bit(name='randombits', bit=3)]),
  '01011': ('mm_procedure', [
  CSN1Bit(name='randombits', bit=3)]),
  '01100': ('single_block_without_tbf_establishment', [
  CSN1Bit(name='randombits', bit=3)]),
  '011010': ('one_phase_access_request_in_rlc_unack_mode', [
  CSN1Bit(name='randombits', bit=2)]),
  '011011': ('dedicated_channel_request', [
  CSN1Bit(name='randombits', bit=2)]),
  '011100': ('emergency_call', [
  CSN1Bit(name='randombits', bit=2)]),
  '01111': ('single_block_mbms_access', [
  CSN1Bit(name='randombits', bit=3)]),
  '1': ('one_phase_access_request', [
  CSN1Bit(name='multislotclass', bit=5),
  CSN1Bit(name='randombits', bit=2)])})

