# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/ms_network_capability_value_part.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 24.008 - d90
# section: 10.5.5.12 MS network capability
# top-level object: MS network capability value part



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_bits = CSN1Bit(name='spare_bits', num=-1)
Spare_bits = spare_bits
Spare_Bits = spare_bits

extended_gea_bits = CSN1List(name='extended_gea_bits', list=[
  CSN1Bit(name='gea_2'),
  CSN1Bit(name='gea_3'),
  CSN1Bit(name='gea_4'),
  CSN1Bit(name='gea_5'),
  CSN1Bit(name='gea_6'),
  CSN1Bit(name='gea_7')])

gea1_bits = CSN1Bit(name='gea1_bits')

ms_network_capability_value_part = CSN1List(name='ms_network_capability_value_part', trunc=True, list=[
  CSN1Ref(obj=gea1_bits),
  CSN1Bit(name='sm_capabilities_via_dedicated_channels'),
  CSN1Bit(name='sm_capabilities_via_gprs_channels'),
  CSN1Bit(name='ucs2_support'),
  CSN1Bit(name='ss_screening_indicator', bit=2),
  CSN1Bit(name='solsa_capability'),
  CSN1Bit(name='revision_level_indicator'),
  CSN1Bit(name='pfc_feature_mode'),
  CSN1Ref(obj=extended_gea_bits),
  CSN1Bit(name='lcs_va_capability'),
  CSN1Bit(name='ps_inter_rat_ho_from_geran_to_utran_iu_mode_capability'),
  CSN1Bit(name='ps_inter_rat_ho_from_geran_to_e_utran_s1_mode_capability'),
  CSN1Bit(name='emm_combined_procedures_capability'),
  CSN1Bit(name='isr_support'),
  CSN1Bit(name='srvcc_to_geran_utran_capability'),
  CSN1Bit(name='epc_capability'),
  CSN1Bit(name='nf_capability'),
  CSN1Bit(name='geran_network_sharing_capability'),
  CSN1Bit(name='user_plane_integrity_protection_support'),
  CSN1Bit(name='gia_4'),
  CSN1Bit(name='gia_5'),
  CSN1Bit(name='gia_6'),
  CSN1Bit(name='gia_7'),
  CSN1Ref(obj=spare_bits)])

