CREATE TABLE IF NOT EXISTS Branch (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  name VARCHAR(10),
  repo_id CHAR(41),
  commit_id CHAR(41),
  UNIQUE INDEX(repo_id, name)
) ENGINE = INNODB;

CREATE TABLE IF NOT EXISTS FileLockTimestamp (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(40),
  update_time BIGINT NOT NULL,
  UNIQUE INDEX(repo_id)
);

CREATE TABLE IF NOT EXISTS FileLocks (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(40) NOT NULL,
  path TEXT NOT NULL,
  user_name VARCHAR(255) NOT NULL,
  lock_time BIGINT,
  expire BIGINT,
  KEY(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS FolderGroupPerm (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(36) NOT NULL,
  path TEXT NOT NULL,
  permission CHAR(15),
  group_id INTEGER NOT NULL,
  INDEX(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS FolderPermTimestamp (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(36),
  timestamp BIGINT,
  UNIQUE INDEX(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS FolderUserPerm (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(36) NOT NULL,
  path TEXT NOT NULL,
  permission CHAR(15),
  user VARCHAR(255) NOT NULL,
  INDEX(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS GCID (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(36),
  gc_id CHAR(36),
  UNIQUE INDEX(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS GarbageRepos (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(36),
  UNIQUE INDEX(repo_id)
);

CREATE TABLE IF NOT EXISTS InnerPubRepo (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(37),
  permission CHAR(15),
  UNIQUE INDEX (repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS LastGCID (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(36),
  client_id VARCHAR(128),
  gc_id CHAR(36),
  UNIQUE INDEX(repo_id, client_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS OrgGroupRepo (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  org_id INTEGER,
  repo_id CHAR(37),
  group_id INTEGER,
  owner VARCHAR(255),
  permission CHAR(15),
  UNIQUE INDEX(org_id, group_id, repo_id),
  INDEX (repo_id), INDEX (owner)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS OrgInnerPubRepo (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  org_id INTEGER,
  repo_id CHAR(37),
  UNIQUE INDEX(org_id, repo_id),
  permission CHAR(15)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS OrgQuota (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  org_id INTEGER,
  quota BIGINT,
  UNIQUE INDEX(org_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS OrgRepo (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  org_id INTEGER,
  repo_id CHAR(37),
  user VARCHAR(255),
  UNIQUE INDEX(org_id, repo_id),
  UNIQUE INDEX (repo_id),
  INDEX (org_id, user),
  INDEX(user)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS OrgSharedRepo (
  id INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
  org_id INT,
  repo_id CHAR(37) ,
  from_email VARCHAR(255),
  to_email VARCHAR(255),
  permission CHAR(15),
  INDEX(repo_id),
  INDEX (org_id, repo_id),
  INDEX(from_email), INDEX(to_email)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS OrgUserQuota (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  org_id INTEGER,
  user VARCHAR(255),
  quota BIGINT,
  UNIQUE INDEX(org_id, user)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS Repo (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(37),
  UNIQUE INDEX (repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoFileCount (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(36),
  file_count BIGINT UNSIGNED,
  UNIQUE INDEX(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoGroup (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(37),
  group_id INTEGER,
  user_name VARCHAR(255),
  permission CHAR(15),
  UNIQUE INDEX(group_id, repo_id),
  INDEX (repo_id), INDEX (user_name)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoHead (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(37),
  branch_name VARCHAR(10),
  UNIQUE INDEX(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoHistoryLimit (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(37),
  days INTEGER,
  UNIQUE INDEX(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoInfo (id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(36),
  name VARCHAR(255) NOT NULL,
  update_time BIGINT,
  version INTEGER,
  is_encrypted INTEGER,
  last_modifier VARCHAR(255),
  status INTEGER DEFAULT 0,
  UNIQUE INDEX(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoOwner (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(37),
  owner_id VARCHAR(255),
  UNIQUE INDEX (repo_id),
  INDEX (owner_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoSize (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(37),
  size BIGINT UNSIGNED,
  head_id CHAR(41),
  UNIQUE INDEX (repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoStorageId (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(40) NOT NULL,
  storage_id VARCHAR(255) NOT NULL,
  UNIQUE INDEX(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoSyncError (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  token CHAR(41),
  error_time BIGINT UNSIGNED,
  error_con VARCHAR(1024),
  UNIQUE INDEX(token)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoTokenPeerInfo (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  token CHAR(41),
  peer_id CHAR(41),
  peer_ip VARCHAR(41),
  peer_name VARCHAR(255),
  sync_time BIGINT,
  client_ver VARCHAR(20),
  UNIQUE INDEX(token)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoTrash (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(36),
  repo_name VARCHAR(255),
  head_id CHAR(40),
  owner_id VARCHAR(255),
  size BIGINT(20),
  org_id INTEGER,
  del_time BIGINT,
  UNIQUE INDEX(repo_id),
  INDEX(owner_id),
  INDEX(org_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoUserToken (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(37),
  email VARCHAR(255),
  token CHAR(41),
  UNIQUE INDEX(repo_id, token),
  INDEX (email)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RepoValidSince (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(37),
  timestamp BIGINT,
  UNIQUE INDEX(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RoleQuota (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  role VARCHAR(255),
  quota BIGINT,
  UNIQUE INDEX(role)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS SeafileConf (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  cfg_group VARCHAR(255) NOT NULL,
  cfg_key VARCHAR(255) NOT NULL,
  value VARCHAR(255),
  property INTEGER
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS SharedRepo (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(37) ,
  from_email VARCHAR(255),
  to_email VARCHAR(255),
  permission CHAR(15),
  INDEX (repo_id),
  INDEX(from_email),
  INDEX(to_email)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS SystemInfo (
  id INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
  info_key VARCHAR(256),
  info_value VARCHAR(1024)
);

CREATE TABLE IF NOT EXISTS UserQuota (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  user VARCHAR(255),
  quota BIGINT,
  UNIQUE INDEX(user)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS UserShareQuota (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  user VARCHAR(255),
  quota BIGINT,
  UNIQUE INDEX(user)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS VirtualRepo (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(36),
  origin_repo CHAR(36),
  path TEXT,
  base_commit CHAR(40),
  UNIQUE INDEX(repo_id),
  INDEX(origin_repo)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS WebAP (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(37),
  access_property CHAR(10),
  UNIQUE INDEX(repo_id)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS WebUploadTempFiles (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  repo_id CHAR(40) NOT NULL,
  file_path TEXT NOT NULL,
  tmp_file_path TEXT NOT NULL
) ENGINE=INNODB;
