# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-03-21 08:44


from django.db import migrations, models
import django.db.models.deletion
import seahub.base.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='FileTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', seahub.base.fields.LowerCaseCharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='FileUUIDMap',
            fields=[
                ('uuid', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('repo_id', models.CharField(db_index=True, max_length=36)),
                ('repo_id_parent_path_md5', models.CharField(db_index=True, max_length=100)),
                ('parent_path', models.TextField()),
                ('filename', models.CharField(max_length=1024)),
                ('is_dir', models.BooleanField()),
            ],
        ),
        migrations.CreateModel(
            name='Tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
            ],
        ),
        migrations.AddField(
            model_name='filetag',
            name='tag',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='tags.Tags'),
        ),
        migrations.AddField(
            model_name='filetag',
            name='uuid',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='tags.FileUUIDMap'),
        ),
    ]
