# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-11-10 06:21


from django.db import migrations, models
import django.db.models.deletion
import seahub.base.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('tags', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Draft',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_at', models.DateTimeField(auto_now=True, db_index=True)),
                ('username', seahub.base.fields.LowerCaseCharField(db_index=True, max_length=255)),
                ('origin_repo_id', models.CharField(max_length=36)),
                ('origin_file_version', models.CharField(max_length=100)),
                ('draft_file_path', models.CharField(max_length=1024)),
                ('origin_file_uuid', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='tags.FileUUIDMap')),
            ],
            options={
                'ordering': ['-created_at', '-updated_at'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DraftReview',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_at', models.DateTimeField(auto_now=True, db_index=True)),
                ('creator', seahub.base.fields.LowerCaseCharField(db_index=True, max_length=255)),
                ('status', models.CharField(max_length=20)),
                ('origin_repo_id', models.CharField(max_length=36)),
                ('draft_file_path', models.CharField(max_length=1024)),
                ('origin_file_version', models.CharField(max_length=100)),
                ('publish_file_version', models.CharField(max_length=100, null=True)),
                ('draft_id', models.OneToOneField(null=True, on_delete=django.db.models.deletion.SET_NULL, to='drafts.Draft')),
                ('origin_file_uuid', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='tags.FileUUIDMap')),
            ],
            options={
                'ordering': ['-created_at', '-updated_at'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ReviewComment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_at', models.DateTimeField(auto_now=True, db_index=True)),
                ('author', seahub.base.fields.LowerCaseCharField(db_index=True, max_length=255)),
                ('resolved', models.BooleanField(db_index=True, default=False)),
                ('comment', models.TextField()),
                ('detail', models.TextField()),
                ('review_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='drafts.DraftReview')),
            ],
            options={
                'ordering': ['-created_at', '-updated_at'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ReviewReviewer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reviewer', seahub.base.fields.LowerCaseCharField(db_index=True, max_length=255)),
                ('review_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='drafts.DraftReview')),
            ],
        ),
    ]
