# encoding: ascii-8bit
# frozen-string-literal: false
#
# The module storing Ruby interpreter configurations on building.
#
# This file was created by mkconfig.rb when ruby was built.  It contains
# build information for ruby which is used e.g. by mkmf to build
# compatible native extensions.  Any changes made to this file will be
# lost the next time ruby is built.

module RbConfig
  RUBY_VERSION.start_with?("3.0.") or
    raise "ruby lib version (3.0.5) doesn't match executable version (#{RUBY_VERSION})"

  # Ruby installed directory.
  TOPDIR = File.dirname(__FILE__).chomp!("/lib/ruby/3.0/i486-linux-gnu")
  # DESTDIR on make install.
  DESTDIR = '' unless defined? DESTDIR
  # The hash configurations stored.
  CONFIG = {}
  CONFIG["DESTDIR"] = DESTDIR
  CONFIG["MAJOR"] = "3"
  CONFIG["MINOR"] = "0"
  CONFIG["TEENY"] = "5"
  CONFIG["PATCHLEVEL"] = "211"
  CONFIG["INSTALL"] = '/usr/bin/install -c'
  CONFIG["EXEEXT"] = ""
  CONFIG["prefix"] = (TOPDIR || DESTDIR + "/usr")
  CONFIG["ruby_install_name"] = "$(RUBY_BASE_NAME)"
  CONFIG["RUBY_INSTALL_NAME"] = "$(RUBY_BASE_NAME)"
  CONFIG["RUBY_SO_NAME"] = "$(RUBY_BASE_NAME)"
  CONFIG["exec"] = "exec"
  CONFIG["ruby_pc"] = "ruby-3.0.pc"
  CONFIG["CC_WRAPPER"] = ""
  CONFIG["PACKAGE"] = "ruby"
  CONFIG["BUILTIN_TRANSSRCS"] = " enc/trans/newline.c"
  CONFIG["MANTYPE"] = "man"
  CONFIG["vendorarchhdrdir"] = "$(vendorhdrdir)/$(sitearch)"
  CONFIG["sitearchhdrdir"] = "$(sitehdrdir)/$(sitearch)"
  CONFIG["rubyarchhdrdir"] = "$(rubyhdrdir)/$(arch)"
  CONFIG["vendorhdrdir"] = "$(rubyhdrdir)/vendor_ruby"
  CONFIG["sitehdrdir"] = "$(rubyhdrdir)/site_ruby"
  CONFIG["rubyhdrdir"] = "$(includedir)/$(RUBY_VERSION_NAME)"
  CONFIG["RUBY_SEARCH_PATH"] = ""
  CONFIG["UNIVERSAL_INTS"] = ""
  CONFIG["UNIVERSAL_ARCHNAMES"] = ""
  CONFIG["configure_args"] = " '--target=i486-openwrt-linux' '--host=i486-openwrt-linux' '--build=x86_64-pc-linux-gnu' '--program-prefix=' '--program-suffix=' '--prefix=/usr' '--exec-prefix=/usr' '--bindir=/usr/bin' '--sbindir=/usr/sbin' '--libexecdir=/usr/lib' '--sysconfdir=/etc' '--datadir=/usr/share' '--localstatedir=/var' '--mandir=/usr/man' '--infodir=/usr/info' '--disable-nls' '--enable-shared' '--enable-static' '--disable-rpath' '--enable-ipv6' '--disable-install-doc' '--disable-install-capi' '--with-ruby-version=minor' '--with-iconv-dir=/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub' '--without-ext=win32,win32ole' '--with-bundled-sha1' '--with-bundled-md5' '--with-bundled-rmd160' '--with-bundled-sha2' '--disable-jit-support' 'build_alias=x86_64-pc-linux-gnu' 'host_alias=i486-openwrt-linux' 'target_alias=i486-openwrt-linux' 'AR=i486-openwrt-linux-musl-gcc-ar' 'AS=i486-openwrt-linux-musl-gcc -c -Os -pipe -march=pentium4 -fno-caller-saves -fno-plt -fhonour-copts -Wno-error=unused-but-set-variable -Wno-error=unused-result -ffile-prefix-map=/builder/shared-workdir/build/sdk/build_dir/target-i386_pentium4_musl/ruby-3.0.5=ruby-3.0.5 -Wformat -Werror=format-security -fstack-protector -D_FORTIFY_SOURCE=1 -Wl,-z,now -Wl,-z,relro -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/include -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/include' 'CC=i486-openwrt-linux-musl-gcc' 'CXX=i486-openwrt-linux-musl-g++' 'LD=i486-openwrt-linux-musl-ld' 'NM=i486-openwrt-linux-musl-gcc-nm' 'OBJCOPY=i486-openwrt-linux-musl-objcopy' 'OBJDUMP=i486-openwrt-linux-musl-objdump' 'RANLIB=i486-openwrt-linux-musl-gcc-ranlib' 'STRIP=i486-openwrt-linux-musl-strip' 'CFLAGS=-Os -pipe -march=pentium4 -fno-caller-saves -fno-plt -fhonour-copts -Wno-error=unused-but-set-variable -Wno-error=unused-result -ffile-prefix-map=/builder/shared-workdir/build/sdk/build_dir/target-i386_pentium4_musl/ruby-3.0.5=ruby-3.0.5 -Wformat -Werror=format-security -fstack-protector -D_FORTIFY_SOURCE=1 -Wl,-z,now -Wl,-z,relro -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/include -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/include ' 'LDFLAGS=-L/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/usr/lib -L/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/lib -znow -zrelro -L/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/lib -Wl,-rpath-link=/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/lib -L/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/lib -Wl,-rpath-link=/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/lib -L/builder/shared-workdir/build/sdk/build_dir/target-i386_pentium4_musl/ruby-3.0.5 ' 'CPPFLAGS=-I/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/usr/include -I/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/include/fortify -I/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/include -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/include -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/include ' 'CXXFLAGS=-Os -pipe -march=pentium4 -fno-caller-saves -fno-plt -fhonour-copts -Wno-error=unused-but-set-variable -Wno-error=unused-result -ffile-prefix-map=/builder/shared-workdir/build/sdk/build_dir/target-i386_pentium4_musl/ruby-3.0.5=ruby-3.0.5 -Wformat -Werror=format-security -fstack-protector -D_FORTIFY_SOURCE=1 -Wl,-z,now -Wl,-z,relro -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/include -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/include '"
  CONFIG["CONFIGURE"] = "configure"
  CONFIG["vendorarchdir"] = "$(vendorlibdir)/$(sitearch)"
  CONFIG["vendorlibdir"] = "$(vendordir)/$(ruby_version)"
  CONFIG["vendordir"] = "$(rubylibprefix)/vendor_ruby"
  CONFIG["sitearchdir"] = "$(sitelibdir)/$(sitearch)"
  CONFIG["sitelibdir"] = "$(sitedir)/$(ruby_version)"
  CONFIG["sitedir"] = "$(rubylibprefix)/site_ruby"
  CONFIG["rubyarchdir"] = "$(rubylibdir)/$(arch)"
  CONFIG["rubylibdir"] = "$(rubylibprefix)/$(ruby_version)"
  CONFIG["ruby_version"] = "3.0"
  CONFIG["sitearch"] = "$(arch)"
  CONFIG["arch"] = "i486-linux-gnu"
  CONFIG["sitearchincludedir"] = "$(includedir)/$(sitearch)"
  CONFIG["archincludedir"] = "$(includedir)/$(arch)"
  CONFIG["sitearchlibdir"] = "$(libdir)/$(sitearch)"
  CONFIG["archlibdir"] = "$(libdir)/$(arch)"
  CONFIG["libdirname"] = "libdir"
  CONFIG["RUBY_EXEC_PREFIX"] = "/usr"
  CONFIG["RUBY_LIB_VERSION"] = ""
  CONFIG["RUBY_LIB_VERSION_STYLE"] = "2\t/* minor */"
  CONFIG["RI_BASE_NAME"] = "ri"
  CONFIG["ridir"] = "$(datarootdir)/$(RI_BASE_NAME)"
  CONFIG["rubysitearchprefix"] = "$(rubylibprefix)/$(sitearch)"
  CONFIG["rubyarchprefix"] = "$(rubylibprefix)/$(arch)"
  CONFIG["MAKEFILES"] = "Makefile GNUmakefile"
  CONFIG["PLATFORM_DIR"] = ""
  CONFIG["THREAD_MODEL"] = "pthread"
  CONFIG["SYMBOL_PREFIX"] = ""
  CONFIG["EXPORT_PREFIX"] = ""
  CONFIG["COMMON_HEADERS"] = ""
  CONFIG["COMMON_MACROS"] = ""
  CONFIG["COMMON_LIBS"] = ""
  CONFIG["MAINLIBS"] = "-lz -lpthread -lrt -lrt -lgmp -ldl -lcrypt -lm "
  CONFIG["ENABLE_SHARED"] = "yes"
  CONFIG["DLDSHARED"] = "$(CC) -shared"
  CONFIG["DLDLIBS"] = " -lc"
  CONFIG["SOLIBS"] = "$(MAINLIBS)"
  CONFIG["LIBRUBYARG_SHARED"] = "-l$(RUBY_SO_NAME)"
  CONFIG["LIBRUBYARG_STATIC"] = "-l$(RUBY_SO_NAME)-static $(MAINLIBS)"
  CONFIG["LIBRUBYARG"] = "$(LIBRUBYARG_SHARED)"
  CONFIG["LIBRUBY"] = "$(LIBRUBY_SO)"
  CONFIG["LIBRUBY_ALIASES"] = "$(LIBRUBY_SONAME) lib$(RUBY_SO_NAME).$(SOEXT)"
  CONFIG["LIBRUBY_SONAME"] = "lib$(RUBY_SO_NAME).$(SOEXT).$(RUBY_API_VERSION)"
  CONFIG["LIBRUBY_SO"] = "lib$(RUBY_SO_NAME).$(SOEXT).$(RUBY_PROGRAM_VERSION)"
  CONFIG["LIBRUBY_A"] = "lib$(RUBY_SO_NAME)-static.a"
  CONFIG["RUBYW_INSTALL_NAME"] = ""
  CONFIG["rubyw_install_name"] = ""
  CONFIG["EXTDLDFLAGS"] = ""
  CONFIG["EXTLDFLAGS"] = ""
  CONFIG["strict_warnflags"] = "-std=gnu99"
  CONFIG["warnflags"] = "-Wall -Wextra -Wdeprecated-declarations -Wduplicated-cond -Wimplicit-function-declaration -Wimplicit-int -Wmisleading-indentation -Wpointer-arith -Wwrite-strings -Wimplicit-fallthrough=0 -Wmissing-noreturn -Wno-cast-function-type -Wno-constant-logical-operand -Wno-long-long -Wno-missing-field-initializers -Wno-overlength-strings -Wno-packed-bitfield-compat -Wno-parentheses-equality -Wno-self-assign -Wno-tautological-compare -Wno-unused-parameter -Wno-unused-value -Wsuggest-attribute=format -Wsuggest-attribute=noreturn -Wunused-variable"
  CONFIG["debugflags"] = "-ggdb3"
  CONFIG["optflags"] = "-O3"
  CONFIG["NULLCMD"] = ":"
  CONFIG["ENABLE_DEBUG_ENV"] = ""
  CONFIG["DLNOBJ"] = "dln.o"
  CONFIG["INSTALL_STATIC_LIBRARY"] = "no"
  CONFIG["MJIT_SUPPORT"] = "no"
  CONFIG["EXECUTABLE_EXTS"] = ""
  CONFIG["ARCHFILE"] = ""
  CONFIG["LIBRUBY_RELATIVE"] = "no"
  CONFIG["EXTOUT"] = ".ext"
  CONFIG["PREP"] = "$(arch)-fake.rb"
  CONFIG["CROSS_COMPILING"] = "yes"
  CONFIG["TEST_RUNNABLE"] = "no"
  CONFIG["rubylibprefix"] = "$(libdir)/$(RUBY_BASE_NAME)"
  CONFIG["setup"] = "Setup"
  CONFIG["ENCSTATIC"] = ""
  CONFIG["EXTSTATIC"] = ""
  CONFIG["SOEXT"] = "so"
  CONFIG["TRY_LINK"] = ""
  CONFIG["PRELOADENV"] = "LD_PRELOAD"
  CONFIG["LIBPATHENV"] = "LD_LIBRARY_PATH"
  CONFIG["RPATHFLAG"] = ""
  CONFIG["LIBPATHFLAG"] = " -L%s"
  CONFIG["LINK_SO"] = ""
  CONFIG["ADDITIONAL_DLDFLAGS"] = ""
  CONFIG["ASMEXT"] = "S"
  CONFIG["LIBEXT"] = "a"
  CONFIG["DLEXT2"] = ""
  CONFIG["DLEXT"] = "so"
  CONFIG["LDSHAREDXX"] = "$(CXX) -shared"
  CONFIG["LDSHARED"] = "$(CC) -shared"
  CONFIG["CCDLFLAGS"] = "-fPIC"
  CONFIG["STATIC"] = ""
  CONFIG["ARCH_FLAG"] = ""
  CONFIG["DLDFLAGS"] = "-L/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/usr/lib -L/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/lib -znow -zrelro -L/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/lib -Wl,-rpath-link=/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/lib -L/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/lib -Wl,-rpath-link=/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/lib -L/builder/shared-workdir/build/sdk/build_dir/target-i386_pentium4_musl/ruby-3.0.5  -Wl,--compress-debug-sections=zlib"
  CONFIG["ALLOCA"] = ""
  CONFIG["dsymutil"] = ""
  CONFIG["codesign"] = ""
  CONFIG["POSTLINK"] = ":"
  CONFIG["WERRORFLAG"] = "-Werror"
  CONFIG["CHDIR"] = "cd -P"
  CONFIG["RMALL"] = "rm -fr"
  CONFIG["RMDIRS"] = "rmdir --ignore-fail-on-non-empty -p"
  CONFIG["RMDIR"] = "rmdir --ignore-fail-on-non-empty"
  CONFIG["CP"] = "cp"
  CONFIG["RM"] = "rm -f"
  CONFIG["PKG_CONFIG"] = "/builder/shared-workdir/build/sdk/staging_dir/host/bin/pkg-config"
  CONFIG["DOXYGEN"] = ""
  CONFIG["DOT"] = ""
  CONFIG["MAKEDIRS"] = "/bin/mkdir -p"
  CONFIG["MKDIR_P"] = "/bin/mkdir -p"
  CONFIG["INSTALL_DATA"] = "$(INSTALL) -m 644"
  CONFIG["INSTALL_SCRIPT"] = "$(INSTALL)"
  CONFIG["INSTALL_PROGRAM"] = "$(INSTALL)"
  CONFIG["SET_MAKE"] = ""
  CONFIG["LN_S"] = "ln -s"
  CONFIG["DLLWRAP"] = ""
  CONFIG["WINDRES"] = ""
  CONFIG["ASFLAGS"] = ""
  CONFIG["ARFLAGS"] = "rcD "
  CONFIG["try_header"] = ""
  CONFIG["CC_VERSION_MESSAGE"] = "i486-openwrt-linux-musl-gcc (OpenWrt GCC 8.4.0 r16850-491b784141) 8.4.0\nCopyright (C) 2018 Free Software Foundation, Inc.\nThis is free software; see the source for copying conditions.  There is NO\nwarranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
  CONFIG["CC_VERSION"] = "$(CC) --version"
  CONFIG["MJIT_CC"] = "i486-openwrt-linux-musl-gcc"
  CONFIG["CSRCFLAG"] = ""
  CONFIG["COUTFLAG"] = "-o "
  CONFIG["OUTFLAG"] = "-o "
  CONFIG["CPPOUTFILE"] = "-o conftest.i"
  CONFIG["GNU_LD"] = "yes"
  CONFIG["GCC"] = "yes"
  CONFIG["EGREP"] = "/builder/shared-workdir/build/sdk/staging_dir/host/bin/grep -E"
  CONFIG["GREP"] = "/builder/shared-workdir/build/sdk/staging_dir/host/bin/grep"
  CONFIG["CPP"] = "$(CC) -E"
  CONFIG["CXXFLAGS"] = "-Os -pipe -march=pentium4 -fno-caller-saves -fno-plt -fhonour-copts -Wno-error=unused-but-set-variable -Wno-error=unused-result -ffile-prefix-map=/builder/shared-workdir/build/sdk/build_dir/target-i386_pentium4_musl/ruby-3.0.5=ruby-3.0.5 -Wformat -Werror=format-security -fstack-protector -D_FORTIFY_SOURCE=1 -Wl,-z,now -Wl,-z,relro -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/include -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/include "
  CONFIG["OBJEXT"] = "o"
  CONFIG["CPPFLAGS"] = "-I/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/usr/include -I/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/include/fortify -I/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/include -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/include -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/include  $(DEFS) $(cppflags)"
  CONFIG["LDFLAGS"] = "-L. -L/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/usr/lib -L/builder/shared-workdir/build/sdk/staging_dir/toolchain-i386_pentium4_gcc-8.4.0_musl/lib -znow -zrelro -L/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/lib -Wl,-rpath-link=/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/lib -L/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/lib -Wl,-rpath-link=/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/lib -L/builder/shared-workdir/build/sdk/build_dir/target-i386_pentium4_musl/ruby-3.0.5  -fstack-protector-strong -rdynamic -Wl,-export-dynamic -Wl,--no-as-needed"
  CONFIG["CFLAGS"] = "-Os -pipe -march=pentium4 -fno-caller-saves -fno-plt -fhonour-copts -Wno-error=unused-but-set-variable -Wno-error=unused-result -ffile-prefix-map=/builder/shared-workdir/build/sdk/build_dir/target-i386_pentium4_musl/ruby-3.0.5=ruby-3.0.5 -Wformat -Werror=format-security -fstack-protector -D_FORTIFY_SOURCE=1 -Wl,-z,now -Wl,-z,relro -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/include -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/include  -fPIC"
  CONFIG["STRIP"] = "i486-openwrt-linux-musl-strip -S -x"
  CONFIG["RANLIB"] = "i486-openwrt-linux-musl-gcc-ranlib"
  CONFIG["OBJDUMP"] = "i486-openwrt-linux-musl-objdump"
  CONFIG["OBJCOPY"] = ":"
  CONFIG["NM"] = "i486-openwrt-linux-musl-gcc-nm"
  CONFIG["LD"] = "i486-openwrt-linux-musl-ld"
  CONFIG["CXX"] = "i486-openwrt-linux-musl-g++"
  CONFIG["AS"] = "i486-openwrt-linux-musl-gcc -c -Os -pipe -march=pentium4 -fno-caller-saves -fno-plt -fhonour-copts -Wno-error=unused-but-set-variable -Wno-error=unused-result -ffile-prefix-map=/builder/shared-workdir/build/sdk/build_dir/target-i386_pentium4_musl/ruby-3.0.5=ruby-3.0.5 -Wformat -Werror=format-security -fstack-protector -D_FORTIFY_SOURCE=1 -Wl,-z,now -Wl,-z,relro -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libiconv-stub/include -I/builder/shared-workdir/build/sdk/staging_dir/target-i386_pentium4_musl/usr/lib/libintl-stub/include"
  CONFIG["AR"] = "i486-openwrt-linux-musl-gcc-ar"
  CONFIG["CC"] = "i486-openwrt-linux-musl-gcc"
  CONFIG["target_os"] = "linux-gnu"
  CONFIG["target_vendor"] = "openwrt"
  CONFIG["target_cpu"] = "i486"
  CONFIG["target"] = "i486-openwrt-linux-gnu"
  CONFIG["host_os"] = "linux-gnu"
  CONFIG["host_vendor"] = "openwrt"
  CONFIG["host_cpu"] = "i486"
  CONFIG["host"] = "i486-openwrt-linux-gnu"
  CONFIG["build_os"] = "linux-gnu"
  CONFIG["build_vendor"] = "pc"
  CONFIG["build_cpu"] = "x86_64"
  CONFIG["build"] = "x86_64-pc-linux-gnu"
  CONFIG["RUBY_VERSION_NAME"] = "$(RUBY_BASE_NAME)-$(ruby_version)"
  CONFIG["RUBYW_BASE_NAME"] = "rubyw"
  CONFIG["RUBY_BASE_NAME"] = "ruby"
  CONFIG["RUBY_PROGRAM_VERSION"] = "$(MAJOR).$(MINOR).$(TEENY)"
  CONFIG["RUBY_API_VERSION"] = "$(MAJOR).$(MINOR)"
  CONFIG["HAVE_GIT"] = "yes"
  CONFIG["GIT"] = "git"
  CONFIG["cxxflags"] = ""
  CONFIG["cppflags"] = ""
  CONFIG["cflags"] = "$(optflags) $(debugflags) $(warnflags)"
  CONFIG["target_alias"] = "i486-openwrt-linux"
  CONFIG["host_alias"] = "i486-openwrt-linux"
  CONFIG["build_alias"] = "x86_64-pc-linux-gnu"
  CONFIG["LIBS"] = "-lm "
  CONFIG["ECHO_T"] = ""
  CONFIG["ECHO_N"] = "-n"
  CONFIG["ECHO_C"] = ""
  CONFIG["DEFS"] = ""
  CONFIG["mandir"] = "$(DESTDIR)/usr/man"
  CONFIG["localedir"] = "$(datarootdir)/locale"
  CONFIG["libdir"] = "$(exec_prefix)/lib"
  CONFIG["psdir"] = "$(docdir)"
  CONFIG["pdfdir"] = "$(docdir)"
  CONFIG["dvidir"] = "$(docdir)"
  CONFIG["htmldir"] = "$(docdir)"
  CONFIG["infodir"] = "$(DESTDIR)/usr/info"
  CONFIG["docdir"] = "$(datarootdir)/doc/$(PACKAGE)"
  CONFIG["oldincludedir"] = "/usr/include"
  CONFIG["includedir"] = "$(prefix)/include"
  CONFIG["localstatedir"] = "$(DESTDIR)/var"
  CONFIG["sharedstatedir"] = "$(prefix)/com"
  CONFIG["sysconfdir"] = "$(DESTDIR)/etc"
  CONFIG["datadir"] = "$(DESTDIR)/usr/share"
  CONFIG["datarootdir"] = "$(prefix)/share"
  CONFIG["libexecdir"] = "$(DESTDIR)/usr/lib"
  CONFIG["sbindir"] = "$(DESTDIR)/usr/sbin"
  CONFIG["bindir"] = "$(exec_prefix)/bin"
  CONFIG["program_transform_name"] = "s&^&&"
  CONFIG["exec_prefix"] = "$(DESTDIR)/usr"
  CONFIG["PACKAGE_URL"] = ""
  CONFIG["PACKAGE_BUGREPORT"] = ""
  CONFIG["PACKAGE_STRING"] = ""
  CONFIG["PACKAGE_VERSION"] = ""
  CONFIG["PACKAGE_TARNAME"] = ""
  CONFIG["PACKAGE_NAME"] = ""
  CONFIG["PATH_SEPARATOR"] = ":"
  CONFIG["SHELL"] = "/bin/bash"
  CONFIG["UNICODE_VERSION"] = "12.1.0"
  CONFIG["UNICODE_EMOJI_VERSION"] = "12.1"
  CONFIG["archdir"] = "$(rubyarchdir)"
  CONFIG["topdir"] = File.dirname(__FILE__)
  # Almost same with CONFIG. MAKEFILE_CONFIG has other variable
  # reference like below.
  #
  #   MAKEFILE_CONFIG["bindir"] = "$(exec_prefix)/bin"
  #
  # The values of this constant is used for creating Makefile.
  #
  #   require 'rbconfig'
  #
  #   print <<-END_OF_MAKEFILE
  #   prefix = #{RbConfig::MAKEFILE_CONFIG['prefix']}
  #   exec_prefix = #{RbConfig::MAKEFILE_CONFIG['exec_prefix']}
  #   bindir = #{RbConfig::MAKEFILE_CONFIG['bindir']}
  #   END_OF_MAKEFILE
  #
  #   => prefix = /usr/local
  #      exec_prefix = $(prefix)
  #      bindir = $(exec_prefix)/bin  MAKEFILE_CONFIG = {}
  #
  # RbConfig.expand is used for resolving references like above in rbconfig.
  #
  #   require 'rbconfig'
  #   p RbConfig.expand(RbConfig::MAKEFILE_CONFIG["bindir"])
  #   # => "/usr/local/bin"
  MAKEFILE_CONFIG = {}
  CONFIG.each{|k,v| MAKEFILE_CONFIG[k] = v.dup}

  # call-seq:
  #
  #   RbConfig.expand(val)         -> string
  #   RbConfig.expand(val, config) -> string
  #
  # expands variable with given +val+ value.
  #
  #   RbConfig.expand("$(bindir)") # => /home/foobar/all-ruby/ruby19x/bin
  def RbConfig::expand(val, config = CONFIG)
    newval = val.gsub(/\$\$|\$\(([^()]+)\)|\$\{([^{}]+)\}/) {
      var = $&
      if !(v = $1 || $2)
	'$'
      elsif key = config[v = v[/\A[^:]+(?=(?::(.*?)=(.*))?\z)/]]
	pat, sub = $1, $2
	config[v] = false
	config[v] = RbConfig::expand(key, config)
	key = key.gsub(/#{Regexp.quote(pat)}(?=\s|\z)/n) {sub} if pat
	key
      else
	var
      end
    }
    val.replace(newval) unless newval == val
    val
  end
  CONFIG.each_value do |val|
    RbConfig::expand(val)
  end

  # :nodoc:
  # call-seq:
  #
  #   RbConfig.fire_update!(key, val)               -> array
  #   RbConfig.fire_update!(key, val, mkconf, conf) -> array
  #
  # updates +key+ in +mkconf+ with +val+, and all values depending on
  # the +key+ in +mkconf+.
  #
  #   RbConfig::MAKEFILE_CONFIG.values_at("CC", "LDSHARED") # => ["gcc", "$(CC) -shared"]
  #   RbConfig::CONFIG.values_at("CC", "LDSHARED")          # => ["gcc", "gcc -shared"]
  #   RbConfig.fire_update!("CC", "gcc-8")                  # => ["CC", "LDSHARED"]
  #   RbConfig::MAKEFILE_CONFIG.values_at("CC", "LDSHARED") # => ["gcc-8", "$(CC) -shared"]
  #   RbConfig::CONFIG.values_at("CC", "LDSHARED")          # => ["gcc-8", "gcc-8 -shared"]
  #
  # returns updated keys list, or +nil+ if nothing changed.
  def RbConfig.fire_update!(key, val, mkconf = MAKEFILE_CONFIG, conf = CONFIG)
    return if mkconf[key] == val
    mkconf[key] = val
    keys = [key]
    deps = []
    begin
      re = Regexp.new("\\$\\((?:%1$s)\\)|\\$\\{(?:%1$s)\\}" % keys.join('|'))
      deps |= keys
      keys.clear
      mkconf.each {|k,v| keys << k if re =~ v}
    end until keys.empty?
    deps.each {|k| conf[k] = mkconf[k].dup}
    deps.each {|k| expand(conf[k])}
    deps
  end

  # call-seq:
  #
  #   RbConfig.ruby -> path
  #
  # returns the absolute pathname of the ruby command.
  def RbConfig.ruby
    File.join(
      RbConfig::CONFIG["bindir"],
      RbConfig::CONFIG["ruby_install_name"] + RbConfig::CONFIG["EXEEXT"]
    )
  end
end
CROSS_COMPILING = nil unless defined? CROSS_COMPILING
