# encoding: ascii-8bit
# frozen-string-literal: false
#
# The module storing Ruby interpreter configurations on building.
#
# This file was created by mkconfig.rb when ruby was built.  It contains
# build information for ruby which is used e.g. by mkmf to build
# compatible native extensions.  Any changes made to this file will be
# lost the next time ruby is built.

module RbConfig
  RUBY_VERSION.start_with?("2.4.") or
    raise "ruby lib version (2.4.4) doesn't match executable version (#{RUBY_VERSION})"

  # Ruby installed directory.
  TOPDIR = File.dirname(__FILE__).chomp!("/lib/ruby/2.4/mips-linux-gnu")
  # DESTDIR on make install.
  DESTDIR = '' unless defined? DESTDIR
  # The hash configurations stored.
  CONFIG = {}
  CONFIG["DESTDIR"] = DESTDIR
  CONFIG["MAJOR"] = "2"
  CONFIG["MINOR"] = "4"
  CONFIG["TEENY"] = "4"
  CONFIG["PATCHLEVEL"] = "296"
  CONFIG["INSTALL"] = '/usr/bin/install -c'
  CONFIG["EXEEXT"] = ""
  CONFIG["prefix"] = (TOPDIR || DESTDIR + "/usr")
  CONFIG["ruby_install_name"] = "$(RUBY_BASE_NAME)"
  CONFIG["RUBY_INSTALL_NAME"] = "$(RUBY_BASE_NAME)"
  CONFIG["RUBY_SO_NAME"] = "$(RUBY_BASE_NAME)"
  CONFIG["exec"] = "exec"
  CONFIG["ruby_pc"] = "ruby-2.4.pc"
  CONFIG["PACKAGE"] = "ruby"
  CONFIG["BUILTIN_TRANSSRCS"] = " enc/trans/newline.c"
  CONFIG["USE_RUBYGEMS"] = "YES"
  CONFIG["MANTYPE"] = "doc"
  CONFIG["NROFF"] = "/usr/bin/nroff"
  CONFIG["vendorarchhdrdir"] = "$(vendorhdrdir)/$(sitearch)"
  CONFIG["sitearchhdrdir"] = "$(sitehdrdir)/$(sitearch)"
  CONFIG["rubyarchhdrdir"] = "$(rubyhdrdir)/$(arch)"
  CONFIG["vendorhdrdir"] = "$(rubyhdrdir)/vendor_ruby"
  CONFIG["sitehdrdir"] = "$(rubyhdrdir)/site_ruby"
  CONFIG["rubyhdrdir"] = "$(includedir)/$(RUBY_VERSION_NAME)"
  CONFIG["RUBY_SEARCH_PATH"] = ""
  CONFIG["UNIVERSAL_INTS"] = ""
  CONFIG["UNIVERSAL_ARCHNAMES"] = ""
  CONFIG["configure_args"] = " '--target=mips-openwrt-linux' '--host=mips-openwrt-linux' '--build=x86_64-linux-gnu' '--program-prefix=' '--program-suffix=' '--prefix=/usr' '--exec-prefix=/usr' '--bindir=/usr/bin' '--sbindir=/usr/sbin' '--libexecdir=/usr/lib' '--sysconfdir=/etc' '--datadir=/usr/share' '--localstatedir=/var' '--mandir=/usr/man' '--infodir=/usr/info' '--disable-nls' '--enable-shared' '--enable-static' '--disable-rpath' '--enable-ipv6' '--disable-install-doc' '--disable-install-capi' '--with-ruby-version=minor' '--with-iconv-dir=/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub' '--without-ext=win32,win32ole' '--with-bundled-sha1' '--with-bundled-md5' '--with-bundled-rmd160' '--with-bundled-sha2' 'build_alias=x86_64-linux-gnu' 'host_alias=mips-openwrt-linux' 'target_alias=mips-openwrt-linux' 'CC=ccache_cc' 'CFLAGS=-Os -pipe -mno-branch-likely -mips32 -mtune=mips32 -fno-caller-saves -fno-plt -fhonour-copts -Wno-error=unused-but-set-variable -Wno-error=unused-result -msoft-float -iremap/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/build_dir/target-mips_mips32_musl-1.1.16/ruby-2.4.4:ruby-2.4.4 -Wformat -Werror=format-security -fstack-protector -D_FORTIFY_SOURCE=1 -Wl,-z,now -Wl,-z,relro -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/include ' 'LDFLAGS=-L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/usr/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/lib -znow -zrelro -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/lib -Wl,-rpath-link=/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/lib -Wl,-rpath-link=/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/build_dir/target-mips_mips32_musl-1.1.16/ruby-2.4.4 ' 'CPPFLAGS=-I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/usr/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/include/fortify -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/include ' 'CXX=ccache_cxx' 'CXXFLAGS=-Os -pipe -mno-branch-likely -mips32 -mtune=mips32 -fno-caller-saves -fno-plt -fhonour-copts -Wno-error=unused-but-set-variable -Wno-error=unused-result -msoft-float -iremap/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/build_dir/target-mips_mips32_musl-1.1.16/ruby-2.4.4:ruby-2.4.4 -Wformat -Werror=format-security -fstack-protector -D_FORTIFY_SOURCE=1 -Wl,-z,now -Wl,-z,relro -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/include '"
  CONFIG["CONFIGURE"] = "configure"
  CONFIG["vendorarchdir"] = "$(vendorlibdir)/$(sitearch)"
  CONFIG["vendorlibdir"] = "$(vendordir)/$(ruby_version)"
  CONFIG["vendordir"] = "$(rubylibprefix)/vendor_ruby"
  CONFIG["sitearchdir"] = "$(sitelibdir)/$(sitearch)"
  CONFIG["sitelibdir"] = "$(sitedir)/$(ruby_version)"
  CONFIG["sitedir"] = "$(rubylibprefix)/site_ruby"
  CONFIG["rubyarchdir"] = "$(rubylibdir)/$(arch)"
  CONFIG["rubylibdir"] = "$(rubylibprefix)/$(ruby_version)"
  CONFIG["ruby_version"] = "2.4"
  CONFIG["sitearch"] = "$(arch)"
  CONFIG["arch"] = "mips-linux-gnu"
  CONFIG["sitearchincludedir"] = "$(includedir)/$(sitearch)"
  CONFIG["archincludedir"] = "$(includedir)/$(arch)"
  CONFIG["sitearchlibdir"] = "$(libdir)/$(sitearch)"
  CONFIG["archlibdir"] = "$(libdir)/$(arch)"
  CONFIG["libdirname"] = "libdir"
  CONFIG["RUBY_EXEC_PREFIX"] = "/usr"
  CONFIG["RUBY_LIB_VERSION"] = ""
  CONFIG["RUBY_LIB_VERSION_STYLE"] = "2\t/* minor */"
  CONFIG["RI_BASE_NAME"] = "ri"
  CONFIG["ridir"] = "$(datarootdir)/$(RI_BASE_NAME)"
  CONFIG["rubysitearchprefix"] = "$(rubylibprefix)/$(sitearch)"
  CONFIG["rubyarchprefix"] = "$(rubylibprefix)/$(arch)"
  CONFIG["MAKEFILES"] = "Makefile GNUmakefile"
  CONFIG["PLATFORM_DIR"] = ""
  CONFIG["THREAD_MODEL"] = "pthread"
  CONFIG["SYMBOL_PREFIX"] = ""
  CONFIG["EXPORT_PREFIX"] = ""
  CONFIG["COMMON_HEADERS"] = ""
  CONFIG["COMMON_MACROS"] = ""
  CONFIG["COMMON_LIBS"] = ""
  CONFIG["MAINLIBS"] = ""
  CONFIG["ENABLE_SHARED"] = "yes"
  CONFIG["DLDLIBS"] = " -lc"
  CONFIG["SOLIBS"] = "$(LIBS)"
  CONFIG["LIBRUBYARG_SHARED"] = "-l$(RUBY_SO_NAME)"
  CONFIG["LIBRUBYARG_STATIC"] = "-l$(RUBY_SO_NAME)-static"
  CONFIG["LIBRUBYARG"] = "$(LIBRUBYARG_SHARED)"
  CONFIG["LIBRUBY"] = "$(LIBRUBY_SO)"
  CONFIG["LIBRUBY_ALIASES"] = "lib$(RUBY_SO_NAME).so.$(MAJOR).$(MINOR) lib$(RUBY_SO_NAME).so"
  CONFIG["LIBRUBY_SO"] = "lib$(RUBY_SO_NAME).so.$(RUBY_PROGRAM_VERSION)"
  CONFIG["LIBRUBY_A"] = "lib$(RUBY_SO_NAME)-static.a"
  CONFIG["RUBYW_INSTALL_NAME"] = ""
  CONFIG["rubyw_install_name"] = ""
  CONFIG["EXTDLDFLAGS"] = ""
  CONFIG["EXTLDFLAGS"] = ""
  CONFIG["strict_warnflags"] = "-std=gnu99"
  CONFIG["warnflags"] = "-Wall -Wextra -Wno-unused-parameter -Wno-parentheses -Wno-long-long -Wno-missing-field-initializers -Wno-tautological-compare -Wno-parentheses-equality -Wno-constant-logical-operand -Wno-self-assign -Wunused-variable -Wimplicit-int -Wpointer-arith -Wwrite-strings -Wdeclaration-after-statement -Wimplicit-function-declaration -Wdeprecated-declarations -Wno-packed-bitfield-compat -Wsuggest-attribute=noreturn -Wsuggest-attribute=format -Wno-maybe-uninitialized"
  CONFIG["debugflags"] = "-ggdb3"
  CONFIG["optflags"] = "-O3 -fno-fast-math"
  CONFIG["NULLCMD"] = ":"
  CONFIG["DLNOBJ"] = "dln.o"
  CONFIG["INSTALL_STATIC_LIBRARY"] = "no"
  CONFIG["EXECUTABLE_EXTS"] = ""
  CONFIG["ARCHFILE"] = ""
  CONFIG["LIBRUBY_RELATIVE"] = "no"
  CONFIG["EXTOUT"] = ".ext"
  CONFIG["PREP"] = "$(arch)-fake.rb"
  CONFIG["CROSS_COMPILING"] = "yes"
  CONFIG["TEST_RUNNABLE"] = "no"
  CONFIG["rubylibprefix"] = "$(libdir)/$(RUBY_BASE_NAME)"
  CONFIG["setup"] = "Setup"
  CONFIG["ENCSTATIC"] = ""
  CONFIG["EXTSTATIC"] = ""
  CONFIG["STRIP"] = "mips-openwrt-linux-musl-strip -S -x"
  CONFIG["TRY_LINK"] = ""
  CONFIG["PRELOADENV"] = "LD_PRELOAD"
  CONFIG["LIBPATHENV"] = "LD_LIBRARY_PATH"
  CONFIG["RPATHFLAG"] = ""
  CONFIG["LIBPATHFLAG"] = " -L%s"
  CONFIG["LINK_SO"] = ""
  CONFIG["ASMEXT"] = "S"
  CONFIG["LIBEXT"] = "a"
  CONFIG["DLEXT2"] = ""
  CONFIG["DLEXT"] = "so"
  CONFIG["LDSHAREDXX"] = "$(CXX) -shared"
  CONFIG["LDSHARED"] = "$(CC) -shared"
  CONFIG["CCDLFLAGS"] = "-fPIC"
  CONFIG["STATIC"] = ""
  CONFIG["ARCH_FLAG"] = ""
  CONFIG["DLDFLAGS"] = "-L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/usr/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/lib -znow -zrelro -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/lib -Wl,-rpath-link=/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/lib -Wl,-rpath-link=/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/build_dir/target-mips_mips32_musl-1.1.16/ruby-2.4.4 "
  CONFIG["ALLOCA"] = ""
  CONFIG["codesign"] = ""
  CONFIG["POSTLINK"] = ":"
  CONFIG["WERRORFLAG"] = "-Werror"
  CONFIG["CHDIR"] = "cd -P"
  CONFIG["RMALL"] = "rm -fr"
  CONFIG["RMDIRS"] = "rmdir --ignore-fail-on-non-empty -p"
  CONFIG["RMDIR"] = "rmdir --ignore-fail-on-non-empty"
  CONFIG["CP"] = "cp"
  CONFIG["RM"] = "rm -f"
  CONFIG["PKG_CONFIG"] = "/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/host/bin/pkg-config"
  CONFIG["PYTHON"] = ""
  CONFIG["DOXYGEN"] = ""
  CONFIG["DOT"] = ""
  CONFIG["MAKEDIRS"] = "/bin/mkdir -p"
  CONFIG["MKDIR_P"] = "/bin/mkdir -p"
  CONFIG["INSTALL_DATA"] = "$(INSTALL) -m 644"
  CONFIG["INSTALL_SCRIPT"] = "$(INSTALL)"
  CONFIG["INSTALL_PROGRAM"] = "$(INSTALL)"
  CONFIG["SET_MAKE"] = ""
  CONFIG["LN_S"] = "ln -s"
  CONFIG["NM"] = "mips-openwrt-linux-musl-gcc-nm"
  CONFIG["DLLWRAP"] = ""
  CONFIG["WINDRES"] = ""
  CONFIG["OBJCOPY"] = ":"
  CONFIG["OBJDUMP"] = "mips-openwrt-linux-musl-objdump"
  CONFIG["ASFLAGS"] = ""
  CONFIG["AS"] = "ccache_cc -c -Os -pipe -mno-branch-likely -mips32 -mtune=mips32 -fno-caller-saves -fno-plt -fhonour-copts -Wno-error=unused-but-set-variable -Wno-error=unused-result -msoft-float -iremap/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/build_dir/target-mips_mips32_musl-1.1.16/ruby-2.4.4:ruby-2.4.4 -Wformat -Werror=format-security -fstack-protector -D_FORTIFY_SOURCE=1 -Wl,-z,now -Wl,-z,relro -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/include"
  CONFIG["ARFLAGS"] = "rcD "
  CONFIG["AR"] = "mips-openwrt-linux-musl-gcc-ar"
  CONFIG["RANLIB"] = "mips-openwrt-linux-musl-gcc-ranlib"
  CONFIG["try_header"] = ""
  CONFIG["CC_VERSION_MESSAGE"] = "mips-openwrt-linux-musl-gcc (LEDE GCC 5.4.0 r3103-1b51a49) 5.4.0\nCopyright (C) 2015 Free Software Foundation, Inc.\nThis is free software; see the source for copying conditions.  There is NO\nwarranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
  CONFIG["CC_VERSION"] = "$(CC) --version"
  CONFIG["CSRCFLAG"] = ""
  CONFIG["COUTFLAG"] = "-o "
  CONFIG["OUTFLAG"] = "-o "
  CONFIG["CPPOUTFILE"] = "-o conftest.i"
  CONFIG["GNU_LD"] = "yes"
  CONFIG["LD"] = "mips-openwrt-linux-musl-ld"
  CONFIG["GCC"] = "yes"
  CONFIG["EGREP"] = "/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/host/bin/grep -E"
  CONFIG["GREP"] = "/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/host/bin/grep"
  CONFIG["CPP"] = "$(CC) -E"
  CONFIG["CXXFLAGS"] = "-Os -pipe -mno-branch-likely -mips32 -mtune=mips32 -fno-caller-saves -fno-plt -fhonour-copts -Wno-error=unused-but-set-variable -Wno-error=unused-result -msoft-float -iremap/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/build_dir/target-mips_mips32_musl-1.1.16/ruby-2.4.4:ruby-2.4.4 -Wformat -Werror=format-security -fstack-protector -D_FORTIFY_SOURCE=1 -Wl,-z,now -Wl,-z,relro -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/include "
  CONFIG["OBJEXT"] = "o"
  CONFIG["CPPFLAGS"] = "-I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/usr/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/include/fortify -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/include  $(DEFS) $(cppflags)"
  CONFIG["LDFLAGS"] = "-L. -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/usr/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/toolchain-mips_mips32_gcc-5.4.0_musl-1.1.16/lib -znow -zrelro -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/lib -Wl,-rpath-link=/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/lib -Wl,-rpath-link=/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/lib -L/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/build_dir/target-mips_mips32_musl-1.1.16/ruby-2.4.4  -fstack-protector -rdynamic -Wl,-export-dynamic"
  CONFIG["CFLAGS"] = "-Os -pipe -mno-branch-likely -mips32 -mtune=mips32 -fno-caller-saves -fno-plt -fhonour-copts -Wno-error=unused-but-set-variable -Wno-error=unused-result -msoft-float -iremap/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/build_dir/target-mips_mips32_musl-1.1.16/ruby-2.4.4:ruby-2.4.4 -Wformat -Werror=format-security -fstack-protector -D_FORTIFY_SOURCE=1 -Wl,-z,now -Wl,-z,relro -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libiconv-stub/include -I/build/lede-17.01/slaves/phase2/mips_mips32/build/sdk/staging_dir/target-mips_mips32_musl-1.1.16/usr/lib/libintl-stub/include  -fPIC"
  CONFIG["CXX"] = "ccache_cxx"
  CONFIG["CC"] = "ccache_cc"
  CONFIG["NACL_LIB_PATH"] = ""
  CONFIG["NACL_SDK_VARIANT"] = ""
  CONFIG["NACL_SDK_ROOT"] = ""
  CONFIG["NACL_TOOLCHAIN"] = ""
  CONFIG["target_os"] = "linux-gnu"
  CONFIG["target_vendor"] = "openwrt"
  CONFIG["target_cpu"] = "mips"
  CONFIG["target"] = "mips-openwrt-linux-gnu"
  CONFIG["host_os"] = "linux-gnu"
  CONFIG["host_vendor"] = "openwrt"
  CONFIG["host_cpu"] = "mips"
  CONFIG["host"] = "mips-openwrt-linux-gnu"
  CONFIG["RUBY_VERSION_NAME"] = "$(RUBY_BASE_NAME)-$(ruby_version)"
  CONFIG["RUBYW_BASE_NAME"] = "rubyw"
  CONFIG["RUBY_BASE_NAME"] = "ruby"
  CONFIG["build_os"] = "linux-gnu"
  CONFIG["build_vendor"] = "pc"
  CONFIG["build_cpu"] = "x86_64"
  CONFIG["build"] = "x86_64-pc-linux-gnu"
  CONFIG["RUBY_PROGRAM_VERSION"] = "2.4.4"
  CONFIG["cxxflags"] = "$(optflags) $(debugflags) $(warnflags)"
  CONFIG["cppflags"] = ""
  CONFIG["cflags"] = "$(optflags) $(debugflags) $(warnflags)"
  CONFIG["target_alias"] = "mips-openwrt-linux"
  CONFIG["host_alias"] = "mips-openwrt-linux"
  CONFIG["build_alias"] = "x86_64-linux-gnu"
  CONFIG["LIBS"] = "-lpthread -lgmp -ldl -lcrypt -lm "
  CONFIG["ECHO_T"] = ""
  CONFIG["ECHO_N"] = "-n"
  CONFIG["ECHO_C"] = ""
  CONFIG["DEFS"] = ""
  CONFIG["mandir"] = "$(DESTDIR)/usr/man"
  CONFIG["localedir"] = "$(datarootdir)/locale"
  CONFIG["libdir"] = "$(exec_prefix)/lib"
  CONFIG["psdir"] = "$(docdir)"
  CONFIG["pdfdir"] = "$(docdir)"
  CONFIG["dvidir"] = "$(docdir)"
  CONFIG["htmldir"] = "$(docdir)"
  CONFIG["infodir"] = "$(DESTDIR)/usr/info"
  CONFIG["docdir"] = "$(datarootdir)/doc/$(PACKAGE)"
  CONFIG["oldincludedir"] = "/usr/include"
  CONFIG["includedir"] = "$(prefix)/include"
  CONFIG["localstatedir"] = "$(DESTDIR)/var"
  CONFIG["sharedstatedir"] = "$(prefix)/com"
  CONFIG["sysconfdir"] = "$(DESTDIR)/etc"
  CONFIG["datadir"] = "$(DESTDIR)/usr/share"
  CONFIG["datarootdir"] = "$(prefix)/share"
  CONFIG["libexecdir"] = "$(DESTDIR)/usr/lib"
  CONFIG["sbindir"] = "$(DESTDIR)/usr/sbin"
  CONFIG["bindir"] = "$(exec_prefix)/bin"
  CONFIG["program_transform_name"] = "s&^&&"
  CONFIG["exec_prefix"] = "$(DESTDIR)/usr"
  CONFIG["PACKAGE_URL"] = ""
  CONFIG["PACKAGE_BUGREPORT"] = ""
  CONFIG["PACKAGE_STRING"] = ""
  CONFIG["PACKAGE_VERSION"] = ""
  CONFIG["PACKAGE_TARNAME"] = ""
  CONFIG["PACKAGE_NAME"] = ""
  CONFIG["PATH_SEPARATOR"] = ":"
  CONFIG["SHELL"] = "/bin/bash"
  CONFIG["UNICODE_VERSION"] = "9.0.0"
  CONFIG["archdir"] = "$(rubyarchdir)"
  CONFIG["topdir"] = File.dirname(__FILE__)
  # Almost same with CONFIG. MAKEFILE_CONFIG has other variable
  # reference like below.
  #
  #   MAKEFILE_CONFIG["bindir"] = "$(exec_prefix)/bin"
  #
  # The values of this constant is used for creating Makefile.
  #
  #   require 'rbconfig'
  #
  #   print <<-END_OF_MAKEFILE
  #   prefix = #{Config::MAKEFILE_CONFIG['prefix']}
  #   exec_prefix = #{Config::MAKEFILE_CONFIG['exec_prefix']}
  #   bindir = #{Config::MAKEFILE_CONFIG['bindir']}
  #   END_OF_MAKEFILE
  #
  #   => prefix = /usr/local
  #      exec_prefix = $(prefix)
  #      bindir = $(exec_prefix)/bin  MAKEFILE_CONFIG = {}
  #
  # RbConfig.expand is used for resolving references like above in rbconfig.
  #
  #   require 'rbconfig'
  #   p Config.expand(Config::MAKEFILE_CONFIG["bindir"])
  #   # => "/usr/local/bin"
  MAKEFILE_CONFIG = {}
  CONFIG.each{|k,v| MAKEFILE_CONFIG[k] = v.dup}

  # call-seq:
  #
  #   RbConfig.expand(val)         -> string
  #   RbConfig.expand(val, config) -> string
  #
  # expands variable with given +val+ value.
  #
  #   RbConfig.expand("$(bindir)") # => /home/foobar/all-ruby/ruby19x/bin
  def RbConfig::expand(val, config = CONFIG)
    newval = val.gsub(/\$\$|\$\(([^()]+)\)|\$\{([^{}]+)\}/) {
      var = $&
      if !(v = $1 || $2)
	'$'
      elsif key = config[v = v[/\A[^:]+(?=(?::(.*?)=(.*))?\z)/]]
	pat, sub = $1, $2
	config[v] = false
	config[v] = RbConfig::expand(key, config)
	key = key.gsub(/#{Regexp.quote(pat)}(?=\s|\z)/n) {sub} if pat
	key
      else
	var
      end
    }
    val.replace(newval) unless newval == val
    val
  end
  CONFIG.each_value do |val|
    RbConfig::expand(val)
  end

  # call-seq:
  #
  #   RbConfig.ruby -> path
  #
  # returns the absolute pathname of the ruby command.
  def RbConfig.ruby
    File.join(
      RbConfig::CONFIG["bindir"],
      RbConfig::CONFIG["ruby_install_name"] + RbConfig::CONFIG["EXEEXT"]
    )
  end
end
CROSS_COMPILING = nil unless defined? CROSS_COMPILING
