use strict;

package Test::Tester::CaptureRunner;

use Test::Tester::Capture;
require Exporter;

sub new
{
	my $pkg = shift;
	my $self = bless {}, $pkg;
	return $self;
}

sub run_tests
{
	my $self = shift;

	my $test = shift;

	capture()->reset;

	$self->{StartLevel} = $Test::Builder::Level;
	&$test();
}

sub get_results
{
	my $self = shift;
	my @results = capture()->details;

	my $start = $self->{StartLevel};
	foreach my $res (@results)
	{
		next if defined $res->{depth};
		my $depth = $res->{_depth} - $res->{_level} - $start - 3;
		$res->{depth} = $depth;
	}

	return @results;
}

sub get_premature
{
	return capture()->premature;
}

sub capture
{
	return Test::Tester::Capture->new;
}

__END__

